#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec3 light_dir;
in vec3 color;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>

void main()
{
	const float SPECULAR_POWER = 8.0;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);
	vec4 nd = texture2D(normal_depth, uv_pos);
	vec3 pos = calc_position(uv_pos, nd.w);

	vec3 n = normalize(nd.xyz);
	//vec3 ev = vec3(0.0, 0.0, 1.0);
	vec3 ev = normalize(-pos);
	vec3 hv = normalize(light_dir + ev);

	float NdotL = max(dot(n, light_dir.xyz), 0.0);
	float NdotHV = max(dot(n, hv), 0.0) * NdotL;

	vec3 lit = ds.rgb*0.15 + color*ds.rgb*NdotL + color*ds.a*pow(NdotHV, SPECULAR_POWER);
	frag_color = vec4(lit, NdotL);
}
