#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;

void main()
{
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
