#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;
uniform sampler2D noise;
uniform sampler2D lines;
uniform float alpha;

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec2 uv;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <geometry_include.frag>
#include <tangentspace_include.frag>

void main()
{
	float a = texture(noise, uv).r;
	if ( a < alpha ) discard;

	float diff = pow(smoothstep(0.0, 0.1, a - alpha), 2.0);

	float a2 = clamp(texture(noise, uv.yx).r, 0.2, 0.4) + clamp(a, 0.4, 0.6);
	float a3 = texture(lines, uv*2.0).r * texture(lines, uv.yx*4.0).r;

	//diffuse_specular.rgb = texture(diffuse, uv).rgb * a2;
	diffuse_specular.rgb = mix(vec3(1.0), texture(diffuse, uv).rgb*a2, diff) * a3;
	diffuse_specular.a = texture(specular, uv).r;

	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uv, t, b);

	vec3 bump = normalize(texture2D(bumpmap, uv).xyz*2.0 - vec3(1.0));

	mat3 mr = mat3(t, b, normalize(normal));
	vec3 n = mr * bump;

	normal_depth.xyz = normalize(n);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
