#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform float time;

in vec3 gs_params[1]; // radius, energy, time

out vec2 uv;
out vec2 params; // alpha, alpha

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	params = vec2(alpha); \
	gl_Position = ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	// check if particle should be rendered
	if ( gs_params[0].x > 0.0 && gs_params[0].z < time )
	{
		vec3 pos = gl_in[0].gl_Position.xyz;
		float radius = gs_params[0].x;

		vec3 cp = vec3(ModelViewMatrix * vec4(gl_in[0].gl_Position.xyz, 1.0));
		float dist = dot(vec3(0.0, 0.0, -1.0), cp) - 1.0;
		float alpha = smoothstep(0.0, 0.5, dist);

		vec3 a = pos + (XAxis + YAxis)*radius;
		vec3 b = pos + (YAxis - XAxis)*radius;
		vec3 c = pos + (-XAxis - YAxis)*radius;
		vec3 d = pos + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
