#version 330 core
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ProjectionMatrix;

in vec4 POSITION;

out float intensity;

void main()
{
	float k = clamp(POSITION.w, 0.0, 1.0);
	intensity = k;
	gl_PointSize = 8.0 + 30.0*smoothstep(0.2, 0.8, 1.0 - k);
	//gl_PointSize = 8.0 + 56.0*smoothstep(0.2, 0.8, 1.0 - k);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION.xyz, 1.0);
	//gl_Position = ProjectionMatrix * vec4(POSITION.xyz, 1.0);
}
