
uniform float time,dist,scale,allscale;
varying vec3 vert,pos,nor;

float signal(float t)
{
	if(t<0.0)
	return 0;
	t=fract(t);
	if(t>.5+(dist)/3.0)
	return 1.0;
	else  
	return 0.0;
}

vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}
uniform int AO_ENABLED;
vec3 rotvec (vec3 invect, float u, float v, float w, float aa)
{
    float ux = u*invect.x;
    float uy = u*invect.y;
    float uz = u*invect.z;
    float vx = v*invect.x;
    float vy = v*invect.y;
    float vz = v*invect.z;
    float wx = w*invect.x;
    float wy = w*invect.y;
    float wz = w*invect.z;
    float sa;
    float ca;
	vec3 ret;
    sa = sin(aa);
    ca = cos(aa);
    ret.x = u*(ux+vy+wz)+(invect.x*(v*v+w*w)-u*(vy+wz))*ca+(-wy+vz)*sa;
    ret.y = v*(ux+vy+wz)+(invect.y*(u*u+w*w)-v*(ux+wz))*ca+(wx-uz)*sa;
    ret.z = w*(ux+vy+wz)+(invect.z*(u*u+v*v)-w*(ux+vy))*ca+(-vx+uy)*sa;
	return ret;
}
float rand1(float co)
{
	float ret;
	ret.x=sin(cos(dot(co*2.0 ,vec2(121.9898,788.2333))) * 437158.5453);
	return fract(ret);
}
void main()
{
	float a,t=time/50.0;
	float i;
	vec3 v=sin(vert)*allscale;

	for(i=1;i<4;i++)
	{	
		v.x-=sin(v.y*i+rand1(i*44)*5008+t)*rand1(i*42);
		v.z+=sin(v.x*i+rand1(i*52)*4005+i-t)*rand1(i*84);
		v.y-=sin(v.z*i+rand1(i*13)*3002-t*2)*rand1(i*34);
	}

		v= rotvec(v,1.0,0.1,2.0,sin(a*800.0+t/100.0)*1000.0)*vec3(scale);
		a+=signal(v.z/200)+signal(v.x/200)+signal(v.y/200);
		v= rotvec(v*vec3(scale),0.0,0.0,1.0,cos(a*121.0+t/14.0)*1800.0)*1.0;
		a+=+signal(v.x/200)+signal(v.y/200)+signal(v.z/200);

	if(a>=1.0)
	a=1.0;
	else
	discard;


	if(AO_ENABLED==0)
	gl_FragColor = vec4(a)*gl_Color;

	if(AO_ENABLED==1)
	{
		gl_FragColor=vec4(packFloatToVec3i(float(pos.z)/500.0),1);
	}
	if(AO_ENABLED==2)
	{
		gl_FragColor=vec4(vec3(.5)*(nor+vec3(1)),1);
	}

}
