varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord;
uniform sampler2D t1,t2,t3;
uniform float v1; 
uniform float dist;
varying vec4 v_position;
varying vec3 v_normal;
vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}
float unpackFloatFromVec4i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}
uniform int AO_ENABLED;
void main (void)
{
	if(AO_ENABLED==0)
	{
	float invRadius=.1/(1.0+dist);
	float distSqr = dot(lightVec, lightVec),a;
	float att = clamp(1.0 - invRadius * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);
	vec3 vVec = normalize(eyeVec);	
	vec4 base = texture2D(t1, texCoord);	
	vec3 bump = normalize( texture2D(t2, texCoord).xyz * 2.0 - 1.0);
	vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
	float diffuse = max( dot(lVec, bump), 0.0 );	
	vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * diffuse;	
	float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),gl_FrontMaterial.shininess );
	vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	a=float(texture2D(t3,texCoord.xy).xyz);
	if(a<v1)
	discard;
	else
	gl_FragColor = vec4((( vAmbient*base + vDiffuse*base + vSpecular) * att).rgb,a);
	}
	if(AO_ENABLED==1)
	{
		gl_FragColor=vec4(packFloatToVec3i(float(v_position.z)/500.0),1);
	}
	if(AO_ENABLED==2)
	{
		gl_FragColor=vec4(vec3(.5)*(v_normal+vec3(1)),1);
	}
}
