varying vec3 lightVec;
varying vec3 eyeVec;
varying vec4 v_position;
varying vec3 v_normal;
uniform float timee,seed,scalee;
float time;

vec4 scalexyz(vec3 xyz,vec4 v)
{
	v*=vec4(xyz,1);
	return v;
}
vec4 rotateAroundX( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( v.x,
				 ca*v.y - sa*v.z,
				 sa*v.y + ca*v.z,
				 v.w );
}

vec4 rotateAroundY( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( sa*v.z + ca*v.x,   v.y,
				 ca*v.z - sa*v.x,   v.w );
}

vec4 rotateAroundZ( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( ca*v.x - sa*v.y,
				 sa*v.x + ca*v.y,
				 v.z, v.w );
}

vec4 rotatexyz(float x,float y, float z,float xc,float yc,float zc,vec4 v)
{
	v+=vec4(xc,yc,zc,0);
	v=rotateAroundX(x,v);
	v=rotateAroundY(y,v);
	v=rotateAroundZ(z,v);
	v-=vec4(xc,yc,zc,0);
	return v;
}

vec4 rotatefunc(vec4 vv)
{	
	vv=scalexyz(vec3(scalee,scalee,scalee),vv);
	vv=rotatexyz(-1.55,0.0,0.0,0.0,0.0,0.0,vv);
	vv=rotatexyz(0.0,0.0,vv.z*7.0+time*10.1,0.0,0.0,0.0,vv);
	vv=rotatexyz(0.0,0.0,vv.z*16.0+time*10.1,0.0,0.1,.5,vv);
	vv=rotatexyz(cos(time*2.0+vv.x*2.0)*.1,sin(time*2.0+vv.x*2.0)*.2,vv.z*8.8+time*3.1,.2,0.5*sin(seed),.4,vv);
	vv=rotatexyz(vv.z*3.2+time*2.1,0.0,0.0,.2,.2,.1,vv);
	vv=scalexyz(vec3(1.0/scalee,1.0/scalee,1.0/scalee),vv);
	
	return vv;
}

void main( void )
{
	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	vec3 t = vec3(0);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);
	gl_FrontColor = gl_Color;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	time=timee/4.0;
	vec4 v=gl_Vertex;
	v=rotatefunc(v);
	v_normal = gl_NormalMatrix * rotatefunc(vec4(gl_Normal.xyz,1)).yxz;
	gl_Position = gl_ModelViewProjectionMatrix * v;
	v_position=gl_Position;
}