uniform sampler2D colormap,normalmap,TGEmap,envmap;
uniform float dist,transp_threshold,glow_threshold,uv_or_gen;
uniform float texturescale; 
varying vec4 v_position;
varying vec3 v_normal;
vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}
float unpackFloatFromVec4i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}
varying vec3 gen1,gen2,gen3;
varying vec3 normal,pos;
varying vec3 lightVec,eyeVec;
vec4 ShadeEnv(sampler2D env,vec3 nor)
{
    vec2 i;
	vec3 rd;
	rd=reflect(pos,nor);
    i.y = dot(normalize(rd),vec3(0.0,1.0,0.0));
    rd.y=0.0;
    i.x = dot(normalize(rd),vec3(1.0,0.0,0.0))*0.5;
	if (rd.z >= 0.0)
    i = (i + 1.0) * 0.5;
    else
    {i.t = (i.t + 1.0) * 0.5;
    i.s = (-i.s) * 0.5 + 1.0;}
	return texture2D(env,i);
}
vec4 ShadeBumpMap(vec2 txcoord)
{
	vec4 ret;
	float invRadius=.1/(1.0+dist);
	float distSqr = dot(lightVec, lightVec),a;
	float att = clamp(1.0 - invRadius * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);
	vec3 vVec = normalize(eyeVec);
	vec4 base = texture2D(colormap, txcoord);
	vec3 bump = normalize( texture2D(normalmap, txcoord).xyz * 2.0 - 1.0);
	vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
	float diffuse = max( dot(lVec, bump), 0.0 );
	vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * diffuse;	
	float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess );
	vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	a=float(texture2D(TGEmap,txcoord.xy).r);
	ret=vec4((( vAmbient*base + vDiffuse*base + vSpecular) * att).rgb,a);
	return ret;
}
vec4 ShadeAll(vec2 uv)
{

	vec4 ret,color,normalcol,envcol;
	color=ShadeBumpMap(uv);
	envcol = ShadeEnv(envmap,normal);
	vec3 TGE=texture2D(TGEmap,uv).xyz;
	ret=(color)*(1.0-TGE.b)+(envcol*TGE.b);
	if(TGE.g>1.0-glow_threshold)
	ret=vec4(1.0,0.0,1.0,.5);	
	if(TGE.r<transp_threshold)
	discard;
	return ret;
}

void main()
{
vec4 col_gen;
	col_gen=(ShadeAll(gen1.xz*texturescale)+ShadeAll(gen2.xz*texturescale)+ShadeAll(gen3.yz*texturescale))/vec4(3);
	gl_FragColor = col_gen*(uv_or_gen)+ShadeAll(gl_TexCoord[0].xy)*(1.0-uv_or_gen);
	if(AO_ENABLED==1)
	gl_FragColor=vec4(packFloatToVec3i(float(v_position.z)/500.0),1);

	if(AO_ENABLED==2)
	gl_FragColor=vec4(vec3(.5)*(v_normal+vec3(1)),1);
}
