
local tex_ppm, tex_width, tex_height

-- this is done only once, when the demo starts
function effect2_load() 
	--print("effect2_load")
--	tex_ppm, tex_width, tex_height = load_texture('ilmari.ppm')
end

-- done just before first _paint
function effect2_init(time) 
	--print("effect2_init "..time)
end

local function set_material()
	glEnable(GL_LIGHT0)
	glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
	glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
	glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

	glEnable(GL_LIGHT1)
	glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
	glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
	glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
	glFrontFace(GL_CW)
end

local buf=0.6
local rotor=0
local timebuf=29821

-- time = milliseconds in song
function effect2_paint(time, params)
	glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)
	realtime = time-13700
	time = (timebuf*0.5)+(time*0.5)
	
	if params.delta then
		time = time + params.delta
	end

	
		
	glMatrixMode(GL_MODELVIEW)
	local angle = 0
	local angle2 = 0
	
	angle = (math.cos(time*0.001)+math.sin(time*0.002))*15
	angle2 = (math.sin(time*0.0015)+math.cos(time*0.0025))*14
	set_material()
	
	glPushMatrix()
	glTranslated(0,0,-5)
	local objr = time*0.01
	glRotated(90,0,1,0)
	glEnable(GL_LIGHTING)
	
--	glEnable(GL_DEPTH_TEST)
	glEnable(GL_NORMALIZE)
--	glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_width, tex_height, 0, GL_RGB, GL_UNSIGNED_BYTE, tex_ppm:ptr())
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_DECAL)
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL)
	glEnable(GL_BLEND)
	glEnable(GL_MULTISAMPLE)
	local i = 0
	
	spectrum = engine_spectrum();
	
	temp = time;
	col = 0;
	col2=0;r=0;b=0;g=0;
	for i = 0, 50 do
		col = col + spectrum[i];
	end
	
	
	
	for i = 0,500 do
		col2 = col2 + spectrum[i];
	end
	
	col2 = ((col2 )*0.3)+(buf*0.7)
	buf = col2
	
	rotor = rotor+(col2*0.02)
	
	if (rotor > 1) then rotor =0 end
	if (rotor < 0 ) then rotor=1 end
	
	-- --print(col2);
	-- col = col + (temp * spectrum[3]);
	-- col = col + (temp * spectrum[4]);
	-- col = col + (temp * spectrum[5]);
	-- col = col + (temp * spectrum[6]);
	-- col = col + (temp * spectrum[8]);
	-- col = col + (temp * spectrum[9]);
	-- col = col + (temp * spectrum[10]);
	
	col = col / 5;
	
	
	
	--time = (time*0.98)+((temp*col*0.001)*0.002);

	local jorn = math.cos(time*0.00002)
	glRotated(jorn*360,0,1,1)
	local joe = 0
	if col > 0.2 then joe=col-0.2
	end

	fade = 0

	if realtime <= 3000 then
                        fade = 1-realtime*0.0002
			if fade <= 0 then fade = 0
			end
        end


	for i = 0, 360 do
		local rot = math.cos(i+time*0.00001)*360-(joe*2)
		glRotated(rot-math.cos(time*0.000001)*360,1-rotor,1-math.cos(time*0.000000001),1-rotor)

		local colr
		local colb
		local colg

		if params.varc then
			if params.varc == 1 then
				colr = 0.3+(0.3*col)+(math.sin(i*0.001+time*0.001)*0.2)
				colg = 0.8-(math.cos(i*0.05+time*0.0015+col)*0.2)
				colb = 0.7-(math.sin(i*0.07+time*0.002)*0.6)*col2
			else		
				colr = 0.7+(0.5*col)+(math.sin(i*0.002+time*0.003)*0.4)
				colg = 0.3-(math.sin(i*0.03+time*0.0025+col)*0.4)
				colb = 0.2-(math.cos(i*0.08+time*0.003)*0.5)*col2
			end
			
		end

		colr = col2*colr
		colg = col2*colg
		colb = col2*colb
		
		if (realtime <= 3000) then
			colr=colr-fade
			colb=colb-fade
			colg=colg-fade
		end

		glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colr, colg, colb, 0.7+math.cos(i*0.06+time*0.0001)*1})
		glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colr, colg, colb, 0.6+math.sin(i*0.06+time*0.0001)*1})
		glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA)

		glBegin(GL_TRIANGLE_STRIP)
				local coordx = math.cos(time*0.001)+math.sin(time*0.0003+i)*1
				local coordy = math.sin(time*0.00015)+math.cos(time*0.00011+i)*3
				local coordz = math.sin(time*0.00014+i+math.cos(i*0.001+time*0.0001)*jorn-i)*1
				
				
				
				glVertex3d(-1-coordx, -1+coordy, 0)
				glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colr, colb, colg, 0.0})
				glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colr, colb, colg, 1.0})
				glVertex3d(-1-coordy, 1+coordx*coordy, 0)
				glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE,  {colg, colr, colb, 0.0})
				glMaterialfv(GL_BACK, GL_AMBIENT_AND_DIFFUSE,  {colg, colr, colb, 1.0})
				glVertex3d(1-coordz, 1+coordz, coordx)
		glEnd()
	end
	glDisable(GL_MULTISAMPLE)
	
	glDisable(GL_LIGHTING)
	glPopMatrix()

	
end

-- called after last _paint
function effect2_deinit()
	--print("effect2_deinit")
end

function effect2_unload()
	--print("effect2_unload")
end
