#include version.txt

varying vec3 normal,lightDir,halfVector;
uniform sampler2D texture;
varying float eyeZ;

void main()
{
	vec3 n,halfV,viewV,ldir;
	float NdotL,NdotHV;
	vec4 color = vec4(0.0, 0.0, 0.0, 1.0);

	n = normalize(normal);

	NdotL = max(dot(n,normalize(lightDir)),0.0);	

	if (NdotL > 0.0) {
		halfV = normalize(halfVector);
		NdotHV = max(dot(n,halfV),0.0);		
		color += texture2D(texture, vec2(NdotHV));		
	}
	
   gl_FragColor = vec4(color.rgb, eyeZ);
}
