
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 1
#endif

#ifndef ADAPTIVE_STEPS
	#define ADAPTIVE_STEPS
#endif

const vec4 fogColor = vec4(0.0, 0.0, 0.0, 1.0);

varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
varying float camdot;

uniform sampler2D t_color;
uniform sampler2D t_disp;
uniform sampler2D t_normal;
uniform float parallaxHeight;
uniform float fogDensity;

void main(void) {
	vec3 e = normalize(eye);

	#ifdef ADAPTIVE_STEPS
		float lod = 32.0+30.0*camdot;
	#else
		float lod = 5.0;
	#endif

	vec2 texcoord = gl_TexCoord[0].xy*16.0;
	float height = texture2D(t_disp, texcoord).r;

	float numSteps = lod;
	numSteps = mix(numSteps*2.0, numSteps, float(e));
	float step = 1.0/numSteps;
	vec2 delta = vec2(-e.x,e.z)*parallaxHeight/(e.y*numSteps);
	float bheight = 1.0;
	int counter = 0;
	while (height < bheight && counter < 100) {
		bheight -= step;
		texcoord += delta;
		height = texture2D(t_disp, texcoord).r;
		counter++;
	}

	vec3 n = normalize(-1.0+2.0*texture2D(t_normal, texcoord).xyz);

	vec4 col = texture2D(t_color, texcoord);
	vec4 final = vec4(0.0);
	vec4 fambient = vec4(0.0);
	vec4 fdiff = vec4(0.0);
	vec4 fspec = vec4(0.0);

	for (int i = 0; i < NUM_LIGHTS; i++) {
		vec3 l = normalize(lightDir[i]);
		float diff = dot(n, l);

		//fambient += gl_LightSource[i].ambient;

		if (diff > 0.0) {
			fdiff += diff;

			vec3 r = reflect(-l, n);
			fspec += vec4(vec3(1.0, 1.0, 1.0), 1.0)*pow(max(dot(r, e), 0.0), 32.0);
		}
	}

	const float LOG2 = 1.442695;
	//const float fogDensity = 0.1;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-fogDensity*fogDensity*z*z*LOG2);
	fogFactor = clamp(fogFactor, 0.0, 1.0);
	fogFactor = 1.0;

	//gl_FragColor = mix(gl_Fog.color, finalColor, fogFactor );

	gl_FragColor = mix(fogColor, fambient*col + fdiff*col + fspec, fogFactor);
//	gl_FragColor = texture2D(t_color, gl_TexCoord[0].xy*2.0);
}
