uniform sampler2D vertextex;
uniform float psize;
varying vec4 color;
varying float dist;
varying vec4 look;


void main() {
  vec4 pos = vec4(texture2DLod(vertextex, gl_MultiTexCoord1.xy, 0.0).rgb, 1.0);
  float dd = length(gl_ModelViewMatrix*pos);
  float br = (1.25-length(pos)/500.0);
  
  color = vec4(vec3(br*1.2, br*0.9, br*0.6), 1.0)*gl_Color;
  look = normalize(gl_ModelViewMatrix*pos);
  dist=dd;
  //color = gl_Color;
  gl_PointSize = (1.0 + 32.0/dd)*psize;
  gl_TexCoord[0] = gl_MultiTexCoord0;
  gl_Position = gl_ModelViewProjectionMatrix*pos;
}

