#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform vec4 AnimationParams; // tile_width, tile_height, width_num_tiles, height_num_tiles

varying in vec3 gs_params[]; // radius, energy, 1/mass
varying out vec3 wpos;
varying out vec2 uv;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	wpos = vec3( gl_ModelViewMatrix * vec4(VTX, 1.0) ); \
	gl_Position = gl_ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	if ( gs_params[0].y <= 0.0 ) return;

	vec3 pos = gl_PositionIn[0].xyz;

	float tile_index = floor((1.0 - gs_params[0].y)*AnimationParams.z*AnimationParams.w);
	float y = floor(tile_index / AnimationParams.z);
	float x = tile_index - y*AnimationParams.z;	
	vec2 tile_pos = vec2(x, y) / AnimationParams.zw;

	float radius = gs_params[0].x;

	vec3 a = pos + (XAxis + YAxis)*radius;
	vec3 b = pos + (YAxis - XAxis)*radius;
	vec3 c = pos + (-XAxis*radius);
	vec3 d = pos + XAxis*radius;

	EMIT_VERTEX(a, tile_pos + vec2(AnimationParams.x, 0.0));
	EMIT_VERTEX(b, tile_pos);
	EMIT_VERTEX(d, tile_pos + AnimationParams.xy);
	EMIT_VERTEX(c, tile_pos + vec2(0.0, AnimationParams.y));

	EndPrimitive();
}
