#version 120

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

varying vec3 light_dir;
varying vec3 color;

#include <deferred_include.frag>

void main()
{
	const float SPECULAR_POWER = 8.0;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);
	vec4 nd = texture2D(normal_depth, uv_pos);

	vec3 n = MAKE_NORMAL(nd.xyz);
	const vec3 ev = vec3(0.0, 0.0, 1.0);

	float NdotL = max(dot(n, light_dir.xyz), 0.1);
	float NdotHV = max(dot(n, ev), 0.0) * NdotL;

	vec3 lit = color*ds.rgb*NdotL + color*ds.a*pow(NdotHV, SPECULAR_POWER);
	gl_FragColor = vec4(lit, 1.0);
}
