#version 120
#extension GL_EXT_geometry_shader4 : enable

varying out vec3 ec_pos;
varying out vec2 pos_zw;

#include <matrix_include.vert>

#define EMIT_VERTEX(VTX, EYE) \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	gl_Position = VTX; \
	EmitVertex()

#define MAKE_QUAD(A, B, C, D) \
	EMIT_VERTEX(vertices[A], ec_eye[A]); \
	EMIT_VERTEX(vertices[B], ec_eye[B]); \
	EMIT_VERTEX(vertices[D], ec_eye[D]); \
	EMIT_VERTEX(vertices[C], ec_eye[C]); \
	EndPrimitive()

vec3 cube_vertices[8] = vec3[](
    vec3( 1.0,  1.0, -1.0),
    vec3(-1.0,  1.0, -1.0),
    vec3(-1.0, -1.0, -1.0),
    vec3( 1.0, -1.0, -1.0),
    vec3( 1.0,  1.0,  1.0),
    vec3(-1.0,  1.0,  1.0),
    vec3(-1.0, -1.0,  1.0),
    vec3( 1.0, -1.0,  1.0)
);

void create_cube(in vec3 center, in float radius)
{
	vec4 vertices[8];
	vec3 ec_eye[8];

	mat3 mr;
	rotate_around_axis(normalize(center), length(center), mr);

	for (int i=0; i < 8; i++)
	{
		vec3 pos = center + mr*(cube_vertices[i]*radius);
		ec_eye[i] = vec3(gl_ModelViewMatrix * vec4(pos, 1.0));
		vertices[i] = gl_ProjectionMatrix * vec4(ec_eye[i], 1.0);
	}

	MAKE_QUAD(3,2,1,0);
	MAKE_QUAD(4,5,6,7);
	MAKE_QUAD(6,5,1,2);
	MAKE_QUAD(7,3,0,4);
	MAKE_QUAD(5,4,0,1);
	MAKE_QUAD(7,6,2,3);
}

void main()
{
	const float max_area = 0.05;
	const float min_area = 0.05 / 9.0;

	vec3 center = (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0;
	vec3 e0 = gl_PositionIn[1].xyz - gl_PositionIn[0].xyz;
	vec3 e1 = gl_PositionIn[2].xyz - gl_PositionIn[0].xyz;
	float area = min( abs(dot(e0, e1)), max_area);
	//if ( area < min_area )
	{
		create_cube(center, area*2.0);
	}
#if 0
	else
	{
		float du = 1.0 / 3.0;
		float dv = 1.0 / 3.0;
		float r = min_area*2.0;
		float u = 0.0;
		while ( u < 1.0 ) {
			float v = 0.0;
			while ( v < 1.0 ) {
				vec3 c = gl_PositionIn[0].xyz*u + gl_PositionIn[1].xyz*v + gl_PositionIn[2].xyz*(1.0 - u - v);
				create_cube(c, r);
				v += dv;
			}
			u += du;
		}
	}
#endif
}
