#version 120
//#extension ARB_draw_buffers : enable

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;

varying vec2 pos_zw;
varying vec3 normal;
varying vec3 ec_pos;
varying vec2 uv;

#include <geometry_include.frag>
#include <tangentspace_include.frag>

void main()
{
	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uv, t, b);

	vec3 bump = normalize(texture2D(bumpmap, uv).xyz*2.0 - vec3(1.0));
	
	mat3 mr = mat3(t, b, normalize(normal));
	vec3 n = mr * bump;

	WRITE_DIFFUSE( texture2D(diffuse, uv).rgb );
	WRITE_SPECULAR( texture2D(specular, uv).r );

	WRITE_NORMAL( n );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
