#version 120
//#extension ARB_draw_buffers : enable

uniform sampler2D diffuse;
uniform sampler2D specular;

varying vec3 ec_pos;
varying vec2 pos_zw;
varying vec2 uv;

#include <geometry_include.frag>

void main()
{
	WRITE_DIFFUSE( texture2D(diffuse, uv).rgb );
	WRITE_SPECULAR( texture2D(specular, uv).r );

	vec3 normal = normalize(cross(dFdx(ec_pos), dFdy(ec_pos)));
	WRITE_NORMAL( normal );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
