#version 120
attribute vec3 POSITION;
attribute vec3 NORMAL;
attribute vec2 TEXCOORD;

uniform float Time;

varying vec2 pos_zw;
varying vec3 normal;
varying vec2 uv;

void main()
{
	vec3 offset = vec3(0.0);
	if ( POSITION.y > 1.0 )
	{
		offset.x = sin(Time + POSITION.z*1.57)*0.5;
		offset.z = cos(Time + POSITION.x*1.57)*0.5;
	}

	uv = TEXCOORD;

	normal = gl_NormalMatrix * NORMAL; //vec3(gl_ModelViewMatrix * vec4(NORMAL, 0.0));

	vec4 proj_pos = gl_ModelViewProjectionMatrix * vec4(POSITION + offset, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
