#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec4  Spline[22]; // x,y,z,time
uniform float Time;
uniform float Spread;
uniform float Wiggle;
uniform float Follow;

varying in vec3 gs_normal[];
varying in vec2 gs_uv[];

varying out vec2 pos_zw;
varying out vec3 normal;
varying out vec2 uv;

#include <matrix_include.vert>

#define PI_OVER_TWO 1.5707963267948966192313216916398

#define EMIT_VERTEX(VTX, NORM, UV) \
	uv = UV; \
	normal = gl_NormalMatrix * NORM; \
	proj_pos = gl_ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	pos_zw = proj_pos.zw; \
	gl_Position = proj_pos; \
	EmitVertex()

vec3 evaluate_spline(in float time)
{
	vec3 p0 = Spline[21].xyz;
	vec3 p1 = Spline[21].xyz;
	vec3 outgoing = vec3(0.0);
	vec3 incomming = vec3(0.0);
	float t=1.0;
	for (int i=0; i < 20; i++)
	{
		if ( time < Spline[i+1].w )
		{
			p0 = Spline[i].xyz;
			p1 = Spline[i+1].xyz;
			if ( i > 0 )
			{
				incomming = (Spline[i+1].xyz - Spline[i-1].xyz) * 0.5;
			}
			outgoing = (Spline[i+2].xyz - Spline[i].xyz) * 0.5;

			t = (time - Spline[i].w) / (Spline[i+1].w - Spline[i].w);
			break;
		}
	}

	float t2 = t*t;
	float t3 = t2*t;
	float h2 = 3.0*t2 - t3 - t3;
	float h1 = 1.0 - h2;
	float h4 = t3 - t2;
	float h3 = h4 - t2 + t;
	return h1*p0 + h2*p1 + h3*incomming + h4*outgoing;
}


void main()
{
	vec3 center = (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0;
	float len = length(center)*16.0;
	//float t = max(Time + (len - 16.0)*(1.0 - Spread), 0.0);
	//float t = max(Time - len*(1.0 - Spread), 0.0);
	float t = max(Time + (len*2.0 - 16.0)*(1.0 - Spread), 0.0);

	vec3 spos = evaluate_spline(t);
	vec3 tpos = mix(spos, spos*Follow + center, Spread);

	float k2 = Wiggle*(1.0 - Spread);
	float angle = t*PI_OVER_TWO;

	tpos.x += sin(angle) * sin(angle*0.9) * k2;
	tpos.z += cos(angle*0.7) * cos(angle*0.6) * k2;
	tpos.y += cos(PI_OVER_TWO+angle*0.5) * cos(PI_OVER_TWO+angle*0.4) * k2;

	mat3 mr;
	//rotate_around_axis(normalize(center), (1.0 - Spread)*t*PI_OVER_TWO, mr);
	rotate_around_axis(normalize(center), t*PI_OVER_TWO, mr);

	vec4 proj_pos;
	for (int i=0; i < 3; i++)
	{
		vec3 v = mr*(gl_PositionIn[i].xyz - center) + tpos;
		vec3 n = mr * gs_normal[i];
		EMIT_VERTEX(v, n, gs_uv[i]);
	}
	EndPrimitive();
}
