#version 120
uniform sampler2D normal_depth;
uniform sampler2D particle;
uniform vec2 viewport;

varying vec3 wpos;
varying vec3 color;
varying vec2 uv;

#include <deferred_include.frag>


void main()
{
	vec4 pcolor = texture2D(particle, uv) * vec4(color, 1.0);
	if ( pcolor.a < 0.0001 ) discard;
	
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture2D(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);
	
	if ( pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*10.0, 0.0, 1.0);
	gl_FragColor = pcolor*alpha;
	//gl_FragColor = vec4(1.0);
}
