#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform vec4 NearPlane;

varying in vec3 gs_light_params[]; // radius
varying in vec3 gs_light_color[];

varying out vec3 wpos;
varying out vec3 color;
varying out vec2 uv;

#define EMIT_VERTEX(VTX, UV) \
	uv = UV; \
	color = gs_light_color[0]; \
	gl_Position = gl_ProjectionMatrix * vec4(VTX, 1.0); \
	wpos = VTX; \
	EmitVertex()

void main()
{
	vec3 pos = gl_PositionIn[0].xyz;
	float radius = gs_light_params[0].x*(1.0/16.0);
	//float dist = dot(NearPlane.xyz, pos) + NearPlane.w;
	//if ( dist < 0.5 ) radius *= dist/0.5;

	vec3 a = pos + (XAxis + YAxis)*radius;
	vec3 b = pos + (YAxis - XAxis)*radius;
	vec3 c = pos + (-XAxis - YAxis)*radius;
	vec3 d = pos + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
