#version 120
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

varying vec3 spot_pos;
varying vec3 spot_dir;
varying vec3 spot_params; //cone_angle, cone_cutoff_angle, radius
varying vec3 color;

#include <deferred_include.frag>


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);
	vec4 nd = texture2D(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);

	vec3 light_dir = spot_pos.xyz - pos;
	float len = length(light_dir);
	if ( len > spot_params.z ) discard;

	light_dir = normalize(light_dir);

	vec3 normal = MAKE_NORMAL(nd.xyz);
	float NdotL = dot(normal, light_dir);
	if ( NdotL <= 0.0 ) discard;

	float atten = 1.0 - (len / spot_params.z);
	atten *= clamp( (dot(-light_dir, spot_dir) - spot_params.x) / (spot_params.y - spot_params.x), 0.0, 1.0 );
	vec3 half_vector = reflect(normalize(pos), light_dir);
	float NdotHV = max(dot(normal, half_vector), 0.0 )*NdotL;

	gl_FragColor.rgb = color*ds.rgb*NdotL*atten + vec3(color*atten)*pow(NdotHV, ds.w);
	gl_FragColor.a = 1.0;
}
