#version 120
uniform sampler2D normal_depth;
uniform vec2 InvViewport;

#include <deferred_include.frag>
#include <shadow_include.frag>


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * InvViewport;
	vec4 nd = texture2D(normal_depth, uv_pos);
	vec3 pos = calc_position(uv_pos, nd.w);

	vec4 lpos = gl_TextureMatrix[0] * vec4(pos, 1.0);
	float shadow_term = 1.0;
	if ( lpos.z > 0.0 )
	{
		lpos /= lpos.w;
		shadow_term = vsm_shadow_first(lpos);
	}

	vec3 shad = vec3(1.0 - (1.0 - shadow_term)*0.75);
	gl_FragColor = vec4(shad, 1.0);
}
