package com.tumbleweed.riseshine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

/*
 *  This activity is for giving the user a "reward" when he scans the last code.
 *  this reward is ment to kickstart that persons morning.
 *  at the moment, the functionality of this reward system
 *  is that it launches up a pre-selected playlists and starts
 *  playing it automatically. 
 *  
 *   For instance, say your last code is at the front door..
 *   when you scan it, you are then ready to leave for work, so it starts playing
 *   your favourite morning tunes. or maybe you have set it up to play a podcast
 *   that is stored on your device.
 */

public class DigitalChocolate extends Activity 
{

	String playlistID;
	RiseShineHelper rsHelper;
	
	 @Override
	    public void onCreate(Bundle savedInstanceState) 
	    {
	        super.onCreate(savedInstanceState);
	        setContentView(R.layout.digchoc);
 
	        rsHelper = new RiseShineHelper();
	        rsHelper.init(this);
	        
	        playlistID = rsHelper.loadPlayListFromFile(this);

	        Intent intent = new Intent(Intent.ACTION_VIEW);
	        intent.setComponent(new ComponentName
	        		("com.android.music","com.android.music.PlaylistBrowserActivity"));
	        intent.setType(MediaStore.Audio.Playlists.CONTENT_TYPE);
	        intent.setFlags(0x10000000);
	        intent.putExtra("oneshot", false);
	        intent.putExtra("playlist", playlistID);
	        Log.d("playlist id", playlistID);
	        
	        
	        
	        AudioManager am =  (AudioManager) getSystemService(AUDIO_SERVICE); 
	        
	        //don't make it too loud.
	        am.setStreamVolume(AudioManager.STREAM_MUSIC,am.getStreamMaxVolume(AudioManager.STREAM_MUSIC)/2,0);
	        
	        startActivity(intent); 

	         
	        
	    }
	 
	 
}
