
float fogDist;
float4 g_FogColor;

uniform extern float4x4 gLightWVP;


texture sw;


float value;


struct Mtrl
{
	float4 ambient;
	float4 diffuse;
	float4 spec;
	float  specPower;
};

struct SpotLight
{
	float4 ambient;
	float4 diffuse;
	float4 spec;
	float3 posW;
	float3 dirW;  
	float  spotPower;
};

uniform extern float4x4  gWorld;
uniform extern float4x4  gWVP;
uniform extern Mtrl      gMtrl;
uniform extern SpotLight gLight;
uniform extern float3    gEyePosW;
uniform extern texture   gTex;
texture  detail_tex,C1,C2,C3,blend_tex,normal;
uniform extern texture   gShadowMap,KRT;



sampler2D tnormal =
sampler_state
{
    Texture = <normal>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};

 
sampler2D detail =
sampler_state
{
    Texture = <detail_tex>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};



sampler2D color2 =
sampler_state
{
    Texture = <C2>;
    MinFilter = point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D color1 =
sampler_state
{
    Texture = <C1>;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D color3 =
sampler_state
{
    Texture = <C3>;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};


sampler2D blend =
sampler_state
{
    Texture = <blend_tex>;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};


void wVS(float3 posL         : POSITION0,
                   float3 normalL      : NORMAL0,
                   float2 tex0         : TEXCOORD0,
                 float fogFactor : FOG,
float2 tex1         : TEXCOORD0,
float2 tex2         : TEXCOORD0,
float2 tex3         : TEXCOORD0,
float2 tex4         : TEXCOORD0,
float2 tex5         : TEXCOORD0,
                   out float4 oPosH    : POSITION0,
                   out float3 oPosW    : TEXCOORD0,
                   out float3 oNormalW : TEXCOORD1,
                   out float3 oToEyeW  : TEXCOORD2,
                   out float2 oTex0    : TEXCOORD3,
                   out float4 oProjTex : TEXCOORD4,
		out float fogFactoro : FOG
)
{
	// Transform to homogeneous clip space.
	oPosH = mul(float4(posL, 1.0f), gWVP);
	
	// Transform vertex position to world space.
	oPosW = mul(float4(posL, 1.0f), gWorld).xyz;
	
	// Transform normal to world space (assume no non-uniform scaling).
	oNormalW = mul(float4(normalL, 0.0f), gWorld).xyz;
	
	// Compute the unit vector from the vertex to the eye.
	oToEyeW = (gEyePosW - oPosW);
	
	// Pass on texture coords to PS
	oTex0 = tex0;
	
	


}




float4 PS(float3 posW    : TEXCOORD0,
                     float3 normalW : TEXCOORD1,
                     float3 toEyeW  : TEXCOORD2,
                     float2 tex0    : TEXCOORD3,
float2 tex1    : TEXCOORD3,
 float2 tex2    : TEXCOORD3,
 float2 tex3    : TEXCOORD3,
 float2 tex4    : TEXCOORD3,
 float2 tex5    : TEXCOORD3,

                     float4 projTex : TEXCOORD4) : COLOR
{
	// Interpolated normals can become unnormal--so normalize.
	
	float3 lightDir = float3(0,1,0);

tex0.x += tex0.x*15;
tex0.y += (tex0.y*12);

	 float3 n = normalize(tex2D(tnormal, tex0).rgb * 1.8 - 1.0f);
      
    float3 l = normalize(lightDir);
    
    float nDotL = saturate(dot(n, l));
 
	
tex2.x +=tex2.x;
tex2.y +=(tex2.y);

tex3.x +=tex3.x*15;
tex3.y +=(tex3.y*12);

tex4.x +=tex4.x*15;
tex4.y +=(tex4.y*12);

	vector TexColor1 = tex2D( color1, tex2 );
    vector TexColor2 = tex2D( color2, tex3 );
    vector TexColor3 = tex2D( color3, tex4 );
    vector BlendMap  = tex2D( blend, tex5 );

   

tex0.x +=tex0.x*10;
tex0.y +=tex0.y*10;
float4 H = tex2D(detail, tex0); 

float4 A = (TexColor3 * BlendMap.r*(sin(value*2)+2))+(TexColor1 * BlendMap.g*value) + (TexColor2 * BlendMap.b);

return A*H+nDotL*1.7;
}



technique Tech
{
    pass P0
    {


        // Specify the vertex and pixel shader associated with this pass.
        vertexShader = compile vs_3_0 wVS();
        pixelShader  = compile ps_3_0 PS();
    }

}



    
