class Team
{
	array<Peer@> members;
	string shapeName;
	string teamName;
}
class Game
{
	array<Peer@> connectedPeers;
	array<Team@> teams;
	array<vec2> spawnPoints;
	
	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	uint roundTime;
	uint waitTime;
	bool roundInProgress;
	
	Timer updateTimer;
	Timer roundTimer;
	
	uint width;
	uint height;
	
	string timerStr;
	
	Game()
	{
		Team blueTeam;
		blueTeam.shapeName = "Circle 1";
		blueTeam.teamName = "blue";
		Team orangeTeam;
		orangeTeam.shapeName = "Circle 3";
		orangeTeam.teamName = "orange";
		
		teams.insertLast(@blueTeam);
		teams.insertLast(@orangeTeam);
		cameraSpeed = 6.0f;
		
		roundTime = 6 * 1000;
		waitTime = 4 * 1000;
		
		roundInProgress = false;
	}
	void InitSpawns()
	{
		// There will be 4 teams in original Hide and Seek, so the maps are compatible, there are 4 types of spawn points
		// unique for each team.
		vec2 spawnPos;
		for (uint t = 1; GetPoint(0,t, spawnPos); t++)
		{
			spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(1,t, spawnPos); t++)
		{
			spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(2,t, spawnPos); t++)
		{
			spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(3,t, spawnPos); t++)
		{
			spawnPoints.insertLast(spawnPos);
		}
	}
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
			cameraMoveTo.Normalize();
			cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
			cameraMoveTo += GetCameraPos();
			SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void ShowPlayerInfo()
	{
		string infoText;
		uint maxLength;
		infoText = "Players:\n";
		maxLength = infoText.length();
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			infoText += connectedPeers[t].peerName;
			infoText += float(connectedPeers[t].timeAsSentry / 1000);
			infoText += "\n";
		}
		DrawGUIText(infoText, vec2(width - 100, 0), 18);
	}
	void OnLoop()
	{
		if (roundInProgress)
			RoundProgress();
		else
			BetweenRounds();
		GetWindowDimensions(width,height);
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		DrawGUIText("Seek and Tag v0.3", vec2(0, 50), 18);
		CameraControls();
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			connectedPeers[t].OnLoop();
		}
		if (updateTimer.GetElapsedTime() > 50)
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
			uint peerCount = 0;
			// Checking whether all peers have a player
			for (uint t = 0; t < connectedPeers.length(); t++)
			{
				if (connectedPeers[t].player !is null)
					peerCount++;
			}
			stream.WriteCompressed(peerCount);
			for (uint it = 0; it < connectedPeers.length(); it++)
			{
				if (connectedPeers[it].player is null)
					continue;
				stream.WriteCompressed(connectedPeers[it].guid);
				stream.Write(connectedPeers[it].player.asset.GetPosition().x);
				stream.Write(connectedPeers[it].player.asset.GetPosition().y);
			}
			// Try - Changing reliability
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE_ORDERED, 2, true);
			updateTimer.Reset();
		}
	}
	void OnRoundEnd()
	{
		// Try nullifiyng peer pointers if they won't be deleted when the game exists - Usually garbage counting should deal with it.
		for (uint t = 0; t < teams.length(); t++)
		{
			while (teams[t].members.length() > 0)
			{
				teams.removeAt(0);
			}
		}
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].player is null)
				continue;
			@connectedPeers[t].player.myPeer = null;
			@connectedPeers[t].player.asset = null;
			@connectedPeers[t].player = null;
		}
		roundInProgress = false;
		roundTimer.Reset();
		BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_ROUND_END));
		stream.SendUA(PP::MEDIUM_PRIORITY, PR::RELIABLE, 0, true);
		print("Round ended!\n");
	}
	void BetweenRounds()
	{
		timerStr = "New round begins in: ";
		timerStr += (waitTime - roundTimer.GetElapsedTime()) / 1000;
		DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	

		if ((waitTime - roundTimer.GetElapsedTime() + 1000) / 1000 <= 0)
		{
			OnRoundBegin();
		}
	}
	void RoundProgress()
	{
		timerStr = "Time left:";
		timerStr += (roundTime - roundTimer.GetElapsedTime()) / 1000;
		DrawGUIText( timerStr, vec2(width / 2 - 30, 0), 18);
		
		if ((roundTime - roundTimer.GetElapsedTime() + 1000) / 1000 <= 0)
		{
			OnRoundEnd();
		}
	}
	void OnRoundBegin()	// Setup all players which were destroyed when the round ended.
	{
		roundTimer.Reset();
		uint playerCount = 0;
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].joinRequested)
				playerCount++;
		}
		print(playerCount);
		BitStream stream0;
		stream0.Write(uint8(NetworkMessages::ID_ROUND_BEGIN));
		stream0.SendUA(PP::MEDIUM_PRIORITY, PR::RELIABLE, 0, true);
		
		// This will be 0 for <3 players
		for (uint sentryCount = playerCount / 2; sentryCount > 0; sentryCount--)
		{
			uint t = rand(0, connectedPeers.length() - 1);
			Peer@ sentry = @connectedPeers[t];
			if (sentry.player !is null ||  !connectedPeers[t].joinRequested)	// Try again
			{
				sentryCount++;
				continue;
			}
			vec2 setupPos = spawnPoints[rand(0, spawnPoints.length() - 1)];
			sentry.SetupPlayer(setupPos, GetTeamByName("orange"));
			GetTeamByName("orange").members.insertLast(sentry);
			uint64 nid = sentry.player.asset.GetNetworkID();
	
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
			stream.WriteCompressed(sentry.guid);
			stream.WriteCompressed(nid);
			stream.Write(setupPos.x);
			stream.Write(setupPos.y);
			stream.WriteCompressed("blue");
			
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			
			for (uint t = 0; t < connectedPeers.length(); t++)
			{
				connectedPeers[t].joinRequested = false;
			}
		}
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			print("Setup players!");
			print(spawnPoints.length());
			Peer@ requesting = connectedPeers[t];
			if (requesting.player !is null || !requesting.joinRequested)
				continue;
			vec2 setupPos = spawnPoints[rand(0, spawnPoints.length() - 1)];
			
			requesting.SetupPlayer(setupPos, GetTeamByName("blue"));
			GetTeamByName("blue").members.insertLast(requesting);
			uint64 nid = requesting.player.asset.GetNetworkID();
	
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
			stream.WriteCompressed(requesting.guid);
			stream.WriteCompressed(nid);
			stream.Write(setupPos.x);
			stream.Write(setupPos.y);
			stream.WriteCompressed("blue");
			
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
		}
		
		roundInProgress = true;
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
				return connectedPeers[t];
		}
		return null;
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
			{
				@connectedPeers[t].player.myPeer = null;
				@connectedPeers[t] = null;
				connectedPeers.removeAt(t);
				break;
			}
		}
	}
	
	Team@ GetTeamByName(string name)
	{
		for (uint t = 0; t < teams.length(); t++)
		{
			if (teams[t].teamName == name)
				return teams[t];
		}
		return null;	
	}
}