class Team
{
	array<Peer@> members;
	string shapeName;
	string teamName;
}
class Game
{
	array<Peer@> connectedPeers;
	array<Team@> teams;
	
	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	Timer updateTimer;
	
	Game()
	{
		Team redTeam;
		redTeam.shapeName = "Circle 2";
		redTeam.teamName = "red";
		Team blueTeam;
		blueTeam.shapeName = "Circle 1";
		blueTeam.teamName = "blue";
		Team orangeTeam;
		orangeTeam.shapeName = "Circle 3";
		orangeTeam.teamName = "orange";
		
		teams.insertLast(@redTeam);
		teams.insertLast(@blueTeam);
		teams.insertLast(@orangeTeam);
		cameraSpeed = 6.0f;
	}
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
		cameraMoveTo.Normalize();
		cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
		cameraMoveTo += GetCameraPos();
		SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void ShowPlayerInfo()
	{
		string infoText;
		uint maxLength;
		infoText = "Players:\n";
		maxLength = infoText.length();
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			infoText += connectedPeers[t].peerName + "\n";
		}
		uint x;
		uint y;
		GetWindowDimensions(x,y);
		DrawGUIText(infoText, vec2(x - 100, 0), 18);
	}
	void OnLoop()
	{
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		DrawGUIText("Seek and Tag v0.3", vec2(0, 50), 18);
		CameraControls();
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			connectedPeers[t].OnLoop();
		}
		
	/*	BitStream stream;
		print("sayhey");
		stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
		stream.Write(uint(connectedPeers.length());
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			stream.Write(connectedPeers[t].guid);
			stream.Write(connectedPeers[t].player.asset.GetPosition().x);
			stream.Write(connectedPeers[t].player.asset.GetPosition().y);
		}*/
		if (updateTimer.GetElapsedTime() > 25)
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
			uint peerCount = 0;
			// Checking whether all peers have a player
			for (uint t = 0; t < connectedPeers.length(); t++)
			{
				if (connectedPeers[t].player !is null)
					peerCount++;
			}
			stream.WriteCompressed(peerCount);
			for (uint it = 0; it < connectedPeers.length(); it++)
			{
				if (connectedPeers[it].player is null)
					continue;
				stream.WriteCompressed(connectedPeers[it].guid);
				stream.Write(connectedPeers[it].player.asset.GetPosition().x);
				stream.Write(connectedPeers[it].player.asset.GetPosition().y);
			}
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE_ORDERED, 2, true);
			updateTimer.Reset();
		}
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
				return connectedPeers[t];
		}
		return null;
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
			{
				@connectedPeers[t].player.myPeer = null;
				@connectedPeers[t] = null;
				connectedPeers.removeAt(t);
				break;
			}
		}
	}
	
	Team@ GetTeamByName(string name)
	{
		for (uint t = 0; t < teams.length(); t++)
		{
			if (teams[t].teamName == name)
				return teams[t];
		}
		return null;	
	}
}