#include "keycodes.as"
#include "peer.as"
#include "game.as"
#include "bullet.as"

Game @game = null;
Input input;

Music intro;

enum NetworkMessages
{
	ID_DISCONNECTION_NOTIFICATION = 21,
	ID_CONNECTION_LOST = 22,
	ID_NEW_PEER_JOINED = 150,	// When a new player joins, it sends this to the server
	ID_NEW_PEER_SYNCH,
	ID_PEER_DISCONNECTED,
	ID_PLAYER_SETUP,	// Called when a new player is initialised
	ID_PLAYER_UPDATE,	// Called to update other players - When it is our player, the player is corrected
	ID_PLAYER_INPUT,	// Sent to server
	ID_PLAYER_HEALTH,	// Called to update Player's health
	ID_PLAYER_DIED,
	ID_BULLET_FIRED		// Sent across when a bullet is fired
}

int main()
{
	game.OnLoop();
	return 1;
}

void OnLoad()
{
	Game g;
	@game = @g;
	
	//LoadShapeSet("basic");
	LoadWorld("deneme");
	
	vec2 point;
	if (GetPoint(0,1,point))
		print(point.x);
	
	//if (intro.OpenFromFile("sounds/Ferit Odman - Nommo.ogg"))
	//intro.Play();
	
	/*CreateStaticAsset("Coolie", vec2(4,3));
	Asset @as = CreateStaticAsset("Coolie", vec2(2,6));
	as.SetRotation(1.5f);
	CreateStaticAsset("Foursided", vec2(4,7));
	CreateStaticAsset("Circle 5", vec2(8,6));*/
	
	AddPacketHandler("NewPeerJoined", NetworkMessages::ID_NEW_PEER_JOINED);
	AddPacketHandler("PlayerSetup", NetworkMessages::ID_PLAYER_SETUP);
	AddPacketHandler("PlayerUpdate", NetworkMessages::ID_PLAYER_UPDATE);
	AddPacketHandler("NewPeerSynch", NetworkMessages::ID_NEW_PEER_SYNCH);
	AddPacketHandler("PeerDisconnected", NetworkMessages::ID_PEER_DISCONNECTED);
	AddPacketHandler("BulletFired", NetworkMessages::ID_BULLET_FIRED);
	AddPacketHandler("PlayerHealth", NetworkMessages::ID_PLAYER_HEALTH);
	AddPacketHandler("PlayerDied", NetworkMessages::ID_PLAYER_DIED);
	
	BitStream stream;
	stream.Write(uint8(NetworkMessages::ID_NEW_PEER_JOINED));
	stream.Write(GetMyGUID());
	stream.WriteCompressed(GetMyName());
	stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
}
void NewPeerJoined(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	bit.IgnoreBytes(1);
	
	uint64 rGUID;
	string name;
	
	Peer newPeer;
	bit.Read(rGUID);
	bit.ReadCompressed(newPeer.peerName);
	newPeer.guid = rGUID;
	
	string peerName;
	
	if (rGUID == GetMyGUID())
	{
	@game.myPeer = @newPeer;
	print("Our peer join request accepted by server!\n");
	}
	else
	{
	game.connectedPeers.insertLast(@newPeer);
	print("New peer joined!\n");
	}
}

void PlayerSetup(uint8 MessageID, uint64 guid, BitStream bit)	// This will be only received from a single client, when it first connects.
{
	print("Player setup received!\n");
	
	uint8 t;
	uint64 rGUID;
	uint64 rNID;
	float rx;
	float ry;
	string requestedTeam;
	
	bit.Read(t);
	bit.ReadCompressed(rGUID);
	
	Peer@ requesting = game.GetPeerByGUID(rGUID);
	if (requesting is null)
	{
		print("Error - PlayerSetup - No GUID match found.\n");
		return;
	}
	
	bit.ReadCompressed(rNID);
	bit.Read(rx);
	bit.Read(ry);
	bit.ReadCompressed(requestedTeam);
	
	vec2 setupPos(rx,ry);
	
	requesting.SetupPlayer(setupPos, game.GetTeamByName(requestedTeam));
	requesting.player.asset.SetNetworkID(rNID);
}
void PlayerUpdate(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	uint64 uGUID;
	vec2 update;
	
	bit.Read(uGUID);
	bit.Read(update.x);
	bit.Read(update.y);
	
	if (uGUID == game.myPeer.guid)
	{
		game.myPeer.player.asset.SetPosition(update);
	}
	else
	{
		if (game.GetPeerByGUID(uGUID).player !is null)
		game.GetPeerByGUID(uGUID).player.PositionUpdate(update);
	}
}
void NewPeerSynch(uint8 MessageID, uint64 guid, BitStream bit)	// When a new peer connects, it needs to be synched. This function will do all the synching
{
	bit.IgnoreBytes(1);
	
	uint peerCount;
	bit.Read(peerCount);
	for (uint t = 0; t < peerCount; t++)
	{
		Peer newPeer;
		uint64 peerGuid;
		uint64 pNid;
		bool peerHasPlayer;
		float px;
		float py;
		string pTeam;
		bit.ReadCompressed(peerGuid);
		bit.ReadCompressed(newPeer.peerName);
		bit.Read(peerHasPlayer);
		if (peerHasPlayer)
		{
			bit.ReadCompressed(pNid);
			bit.Read(px);
			bit.Read(py);
			bit.ReadCompressed(pTeam);
		}
		
		newPeer.guid = peerGuid;
		if (peerHasPlayer)
		{
		newPeer.SetupPlayer(vec2(px,py), game.GetTeamByName(pTeam));
		newPeer.player.asset.SetNetworkID(pNid);
		}
		game.connectedPeers.insertLast(@newPeer);
	}
}
void PeerDisconnected(uint8 MessageID, uint64 guid, BitStream bit)
{
	uint64 disconnectedGUID;
	bit.IgnoreBytes(1);
	bit.ReadCompressed(disconnectedGUID);
	game.RemovePeerByGUID(disconnectedGUID);
}

void BulletFired(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	uint64 firingGuid;
	float px;
	float py;
	float dx;
	float dy;
	
	bit.Read(firingGuid);
	bit.Read(px);
	bit.Read(py);
	bit.Read(dx);
	bit.Read(dy);
	
	Peer@ firingPeer = game.GetPeerByGUID(firingGuid);
	if (firingPeer is null || firingPeer.player is null)
	return;
	
	Bullet@ bullet = cBullet(CreateAsset("Bullet", vec2(px,py), "Bullet"));
	bullet.Shoot(vec2(dx,dy) - firingPeer.player.asset.GetPosition(), firingPeer.player);
}
void PlayerHealth(uint8 MessageID, uint64 guid, BitStream bit)
{
	uint64 pGUID;
	int health;
	bit.IgnoreBytes(1);
	bit.ReadCompressed(pGUID);
	bit.ReadCompressed(health);
	
	game.GetPeerByGUID(pGUID).player.health = health;
}
void PlayerDied(uint8 MessageID, uint64 guid, BitStream bit)
{
	uint64 pGUID;
	bit.IgnoreBytes(1);
	bit.ReadCompressed(pGUID);
	
	Peer@ diedPeer = game.GetPeerByGUID(pGUID);
	diedPeer.setupRequested = false;
	@diedPeer.player.asset = null;
	@diedPeer.player = null;
}