/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.sourceforge.jogg.JOgg;
import org.sourceforge.jogg.JOggProperties;
import org.sourceforge.jogg.WavFilter;
import org.sourceforge.jogg.layout.GBLayout;

public class OptionsWindow
extends JDialog
implements ActionListener,
ItemListener {
    public static final String[] QUALITIES = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public static final String WAVDIR = "CD Drive";
    public static final String OUTDIR = "Output dir";
    private JComboBox _method = new JComboBox<String>(JOggProperties.ENCODER_METHODS);
    private JButton _ok = new JButton("Ok");
    private JButton _cancel = new JButton("Cancel");
    private JOggProperties _properties;
    private JButton _oggExecutable = new JButton("Ogg Encoder");
    private JTextField _oggExtension = new JTextField(5);
    private JTextField _oggExePath = new JTextField(20);
    private JTextField _oggBitrate = new JTextField(4);
    private JComboBox _oggQuality = new JComboBox<String>(QUALITIES);
    private JButton _mp3Executable = new JButton("MP3 Encoder");
    private JTextField _mp3Extension = new JTextField(5);
    private JTextField _mp3ExePath = new JTextField(20);
    private JTextField _mp3Bitrate = new JTextField(4);
    private JTextField _discId = new JTextField(20);
    private JButton _discIdProgram = new JButton("Disc id program");
    private JTextField _localCDDB = new JTextField(20);
    private JButton _localCDDBChooser = new JButton("Local CDDB");
    private JTextField _wavFileDir = new JTextField(20);
    private JTextField _outputDir = new JTextField(20);
    private JButton _selectWavFileDir = new JButton("CD Drive");
    private JButton _selectOutputDir = new JButton("Output dir");

    public OptionsWindow(JFrame f) {
        super(f, "Options", true);
        this.setProperties(JOggProperties.getInstance());
        this.initialise();
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._selectOutputDir) {
            this.displayOutputDirChooser();
        } else if (e.getSource() == this._selectWavFileDir) {
            this.displayWavFileDirChooser();
        } else if (e.getSource() == this._ok) {
            if (this.validateIntegers()) {
                this.saveProperties();
                this.dispose();
            }
        } else if (e.getSource() == this._oggExecutable) {
            this.displayOggEncChooser();
        } else if (e.getSource() == this._mp3Executable) {
            this.displayMP3EncChooser();
        } else if (e.getSource() == this._discIdProgram) {
            this.displayDiscIdChooser();
        } else if (e.getSource() == this._localCDDBChooser) {
            this.displayLocalCDDBChooser();
        } else {
            this.dispose();
        }
    }

    private boolean validateIntegers() {
        if (!this.isInteger(this._oggBitrate.getText())) {
            JOptionPane.showMessageDialog(this, "Ogg bitrate must be an integer value");
            return false;
        }
        if (!this.isInteger(this._mp3Bitrate.getText())) {
            JOptionPane.showMessageDialog(this, "MP3 bitrate must be an integer value");
            return false;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._method) {
            if (e.getStateChange() == 1) {
                this.getProperties().setEncoderMethod(e.getItem().toString());
            }
        } else if (e.getSource() == this._oggQuality && e.getStateChange() == 1) {
            this.getProperties().setOggQuality(Integer.parseInt(e.getItem().toString()));
        }
    }

    private void displayWavFileDirChooser() {
        String dir;
        File[] wavs;
        int accepted = this.displayFileChoice(this._wavFileDir, 1);
        if (accepted == 0 && ((wavs = this.getWavFiles(dir = this._wavFileDir.getText())) == null || wavs.length == 0)) {
            JOptionPane.showMessageDialog(this, "No .wav files exist in this directory", "No .wav Files", 0);
            this.displayWavFileDirChooser();
        }
    }

    private File[] getWavFiles(String dir) {
        File f = new File(dir);
        return f.listFiles(new WavFilter());
    }

    private void displayOutputDirChooser() {
        this.displayFileChoice(this._outputDir, 1);
    }

    private void displayOggEncChooser() {
        this.displayFileChoice(this._oggExePath, 0);
    }

    private void displayDiscIdChooser() {
        this.displayFileChoice(this._discId, 0);
    }

    private void displayMP3EncChooser() {
        this.displayFileChoice(this._mp3ExePath, 0);
    }

    private void displayLocalCDDBChooser() {
        this.displayFileChoice(this._localCDDB, 1);
    }

    private int displayFileChoice(JTextField field, int type) {
        JFileChooser chooser = new JFileChooser(field.getText());
        chooser.setFileSelectionMode(type);
        int accepted = chooser.showDialog(this, "Select");
        if (accepted == 0) {
            field.setText(chooser.getSelectedFile().getAbsolutePath());
        }
        return accepted;
    }

    private void initialise() {
        this.addListeners();
        this.setProperties();
        this._oggExePath.setEditable(false);
        this._mp3ExePath.setEditable(false);
        this._localCDDB.setEditable(false);
        this._outputDir.setEditable(false);
        this._wavFileDir.setEditable(false);
        this.layoutComponents();
    }

    private void setProperties() {
        this._oggExePath.setText(this.getProperties().getOggExecutable());
        this._mp3ExePath.setText(this.getProperties().getMP3Executable());
        this._oggBitrate.setText("" + this.getProperties().getOggBitrate());
        this._mp3Bitrate.setText("" + this.getProperties().getMP3Bitrate());
        this._oggQuality.setSelectedItem("" + this.getProperties().getOggQuality());
        this._oggExtension.setText(this.getProperties().getOggExtension());
        this._mp3Extension.setText(this.getProperties().getMP3Extension());
        this._method.setSelectedItem(this.getProperties().getEncoderMethod());
        this._localCDDB.setText(this.getProperties().getLocalCDDB());
        this._outputDir.setText(this.getProperties().getOutputDir());
        this._wavFileDir.setText(this.getProperties().getWavDir());
        if (!JOgg.isWindows()) {
            this._discId.setText(this.getProperties().getDiscId());
            this._discId.setEditable(false);
        }
    }

    private void addListeners() {
        this._ok.addActionListener(this);
        this._ok.setMnemonic('O');
        this._cancel.addActionListener(this);
        this._cancel.setMnemonic('C');
        this._oggExecutable.addActionListener(this);
        this._oggExecutable.setMnemonic('g');
        this._mp3Executable.addActionListener(this);
        this._mp3Executable.setMnemonic('M');
        this._method.addItemListener(this);
        this._oggQuality.addItemListener(this);
        if (!JOgg.isWindows()) {
            this._discIdProgram.addActionListener(this);
            this._discIdProgram.setMnemonic('i');
        }
        this._localCDDBChooser.addActionListener(this);
        this._localCDDBChooser.setMnemonic('L');
        this._selectOutputDir.addActionListener(this);
        this._selectOutputDir.setMnemonic('u');
        this._selectWavFileDir.addActionListener(this);
        this._selectWavFileDir.setMnemonic('D');
    }

    private void layoutComponents() {
        GBLayout layout = new GBLayout(this.getContentPane());
        layout.addComponent((Component)new JLabel("Encoding Method"), 17);
        layout.addComponent((Component)this._method, layout.getDimensions(2, 1), 17, true);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Ogg", this.getOggPanel());
        tabs.addTab("MP3", this.getMP3Panel());
        layout.addComponent((Component)tabs, layout.getDimensions(3, 1), 10, true);
        layout.addComponent((Component)this.getButtonPanel(), layout.getDimensions(3, 1), 10, true);
        layout.addComponent((Component)this.getControlPanel(), layout.getDimensions(3, 1), 10, true);
    }

    private JPanel getControlPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        panel.add(this._ok);
        panel.add(this._cancel);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        GBLayout layout = new GBLayout(panel);
        layout.addComponent((Component)this._selectOutputDir, 13);
        layout.addComponent((Component)this._outputDir, layout.getDimensions(2, 1), 17, true);
        layout.addComponent((Component)this._selectWavFileDir, 13);
        layout.addComponent((Component)this._wavFileDir, layout.getDimensions(2, 1), 17, true);
        if (!JOgg.isWindows()) {
            layout.addComponent((Component)this._discIdProgram, 13);
            layout.addComponent((Component)this._discId, layout.getDimensions(2, 1), 17, true);
        }
        layout.addComponent((Component)this._localCDDBChooser, 13);
        layout.addComponent((Component)this._localCDDB, layout.getDimensions(2, 1), 17, true);
        return panel;
    }

    private JPanel getOggPanel() {
        JPanel panel = new JPanel();
        GBLayout layout = new GBLayout(panel);
        layout.addComponent((Component)this._oggExecutable, 17);
        layout.addComponent((Component)this._oggExePath, layout.getDimensions(2, 1), 17, true);
        layout.addComponent((Component)new JLabel("Bitrate"), 17);
        layout.addComponent((Component)this._oggBitrate, 17);
        layout.addComponent((Component)new JLabel("kbps"), 17, true);
        layout.addComponent((Component)new JLabel("Quality"), 17);
        layout.addComponent((Component)this._oggQuality, 17);
        layout.addComponent((Component)new JLabel("/10"), 17, true);
        layout.addComponent((Component)new JLabel("Extension"), 17);
        layout.addComponent((Component)this._oggExtension, layout.getDimensions(2, 1), 17, true);
        return panel;
    }

    private JPanel getMP3Panel() {
        JPanel panel = new JPanel();
        GBLayout layout = new GBLayout(panel);
        layout.addComponent((Component)this._mp3Executable, 17);
        layout.addComponent((Component)this._mp3ExePath, layout.getDimensions(2, 1), 17, true);
        layout.addComponent((Component)new JLabel("Bitrate"), 17);
        layout.addComponent((Component)this._mp3Bitrate, 17);
        layout.addComponent((Component)new JLabel("kbps"), 17, true);
        layout.addComponent((Component)new JLabel("Extension"), 17);
        layout.addComponent((Component)this._mp3Extension, layout.getDimensions(2, 1), 17, true);
        return panel;
    }

    private boolean isInteger(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void saveProperties() {
        this.getProperties().setOggBitrate(Integer.parseInt(this._oggBitrate.getText()));
        this.getProperties().setOggExtension(this._oggExtension.getText());
        this.getProperties().setOggExecutable(this._oggExePath.getText());
        this.getProperties().setMP3Executable(this._mp3ExePath.getText());
        this.getProperties().setMP3Extension(this._mp3Extension.getText());
        this.getProperties().setMP3Bitrate(Integer.parseInt(this._mp3Bitrate.getText()));
        this.getProperties().setOutputDir(this._outputDir.getText());
        this.getProperties().setWavDir(this._wavFileDir.getText());
        if (!JOgg.isWindows()) {
            this.getProperties().setDiscId(this._discId.getText());
        }
        this.getProperties().setLocalCDDB(this._localCDDB.getText());
    }

    private void setProperties(JOggProperties properties) {
        this._properties = properties;
    }

    private JOggProperties getProperties() {
        return this._properties;
    }
}

