/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg.thread;

import java.awt.event.ActionEvent;
import java.io.File;
import org.sourceforge.jogg.JOgg;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.event.ThreadEvent;
import org.sourceforge.jogg.thread.JOggThread;
import org.sourceforge.jogg.thread.ProcessThread;

public abstract class EncoderThread
extends JOggThread {
    public static final String PROCESS_RESULT = "Process result: ";
    public static final String PROCESS_EXIT = "Process exit: ";
    public static final String EXECUTING = "Executing ";
    private SongData[] _rows;
    private SongData _row;

    public EncoderThread(SongData[] rows) {
        this._rows = rows;
    }

    public void run() {
        this.notifyStarted();
        int i = 0;
        while (i < this._rows.length) {
            if (!this.shouldRun()) break;
            this.encodeFile(this._rows[i]);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        this.notifyStopped();
    }

    public void actionPerformed(ActionEvent e) {
        this.setShouldRun(false);
        if (this.getThread() != null) {
            this.getThread().destroy();
        }
    }

    protected void notifyEncoded() {
        ThreadEvent e = new ThreadEvent(this, 102);
        this.notifyListeners(e);
    }

    protected void encodeFile(SongData row) {
        block3: {
            String[] cmd = this.getCommandArray(row);
            this.notifyOutput(this.getCommandString(cmd));
            this.setThread(new ProcessThread(cmd));
            this.getThread().start();
            try {
                while (this.getThread().isAlive()) {
                    this.notifyOutput(this.getThread().getProcessOutput());
                    this.notifyOutput(this.getThread().getErrorOutput());
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.getThread() == null) break block3;
                this.getThread().destroy();
            }
        }
        this.notifyOutput(PROCESS_RESULT + this.getThread().getResult() + JOgg.NEW_LINE + PROCESS_EXIT + this.getThread().getExitValue() + JOgg.NEW_LINE);
        this.notifyEncoded();
    }

    protected String getCommandString(String[] cmd) {
        StringBuffer buf = new StringBuffer(EXECUTING);
        int i = 0;
        while (i < cmd.length) {
            buf.append(cmd[i]);
            buf.append(" ");
            ++i;
        }
        buf.append(JOgg.NEW_LINE);
        return buf.toString();
    }

    protected String[] getCommandArray(SongData row) {
        this.setRow(row);
        return this.getCommandArray();
    }

    protected String getOutputFile(String extension) {
        int lastSlash = this.getRow().getFile().lastIndexOf(File.separator);
        int ext = this.getRow().getFile().lastIndexOf(".wav");
        String name = this.getRow().hasSongTitle() ? this.getRow().getSongTitle().replaceAll(" ", "_") : this.getRow().getFile().substring(lastSlash + 1, ext);
        String dir = this.getDir();
        return String.valueOf(dir) + File.separator + name + extension;
    }

    protected String getDir() {
        StringBuffer dir = new StringBuffer(this.getProperties().getOutputDir());
        if (this.getRow().hasArtist()) {
            dir.append(File.separator);
            dir.append(this.directoryfication(this.getRow().getArtist()));
            if (this.getRow().hasAlbum()) {
                dir.append(File.separator);
                dir.append(this.getAlbum());
            }
        }
        this.createMissingDirs(dir.toString());
        return dir.toString();
    }

    protected String directoryfication(String dir) {
        dir = dir.replaceAll("/", "");
        dir = dir.trim();
        dir = dir.replaceAll(" ", "_");
        return dir;
    }

    protected void createMissingDirs(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public SongData getRow() {
        return this._row;
    }

    public void setRow(SongData row) {
        this._row = row;
    }

    protected String getAlbum() {
        String album = this.getRow().getAlbum();
        String artist = this.getRow().getArtist();
        int index = album.indexOf(artist);
        int slash = album.indexOf("/");
        if (index == 0 && slash > 0) {
            album = album.substring(slash);
        }
        return this.directoryfication(album);
    }
}

