/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg.thread;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.sourceforge.jogg.JOggProperties;
import org.sourceforge.jogg.event.ThreadEvent;
import org.sourceforge.jogg.event.ThreadListener;
import org.sourceforge.jogg.thread.ProcessThread;

public abstract class JOggThread
extends Thread
implements ActionListener {
    private JOggProperties _properties;
    private ProcessThread _thread;
    private boolean _shouldRun = true;
    private ArrayList _listeners = new ArrayList();

    protected JOggThread() {
        this.setProperties(JOggProperties.getInstance());
    }

    public void addThreadListener(ThreadListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public abstract void run();

    protected abstract String[] getCommandArray();

    protected JOggProperties getProperties() {
        return this._properties;
    }

    protected void setProperties(JOggProperties properties) {
        this._properties = properties;
    }

    protected ProcessThread getThread() {
        return this._thread;
    }

    protected void setThread(ProcessThread thread) {
        this._thread = thread;
    }

    protected void notifyStarted() {
        ThreadEvent e = new ThreadEvent(this, 99);
        this.notifyListeners(e);
    }

    protected void notifyStopped() {
        ThreadEvent e = new ThreadEvent(this, 100);
        this.notifyListeners(e);
    }

    protected void notifyOutput(String output) {
        if (output != null && output.trim().length() > 0) {
            ThreadEvent e = new ThreadEvent(this, 101, output);
            this.notifyListeners(e);
        }
    }

    protected void notifyListeners(ThreadEvent e) {
        int i = 0;
        while (i < this._listeners.size()) {
            ThreadListener l = (ThreadListener)this._listeners.get(i);
            l.threadEventPerformed(e);
            ++i;
        }
    }

    protected boolean shouldRun() {
        return this._shouldRun;
    }

    protected void setShouldRun(boolean shouldRun) {
        this._shouldRun = shouldRun;
    }

    public abstract void actionPerformed(ActionEvent var1);
}

