/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg.thread;

import java.io.File;
import java.util.ArrayList;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.thread.EncoderThread;

public class OggThread
extends EncoderThread {
    public OggThread(SongData[] rows) {
        super(rows);
    }

    protected String[] getCommandArray() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.getProperties().getOggExecutable());
        cmds.add("--bitrate=" + this.getProperties().getOggBitrate());
        cmds.add("--quality=" + this.getProperties().getOggQuality());
        cmds.add("--output=" + this.getOutputFile(this.getProperties().getOggExtension()));
        if (this.getRow().hasArtist()) {
            cmds.add("--artist=" + this.getRow().getArtist());
        }
        if (this.getRow().hasSongTitle()) {
            cmds.add("--title=" + this.getRow().getSongTitle());
        }
        if (this.getRow().hasAlbum()) {
            cmds.add("--album=" + this.getRow().getAlbum());
        }
        if (this.getRow().hasTrackNum()) {
            cmds.add("--tracknum=" + this.getRow().getTrackNum());
        }
        if (this.getRow().hasGenre()) {
            cmds.add("--genre=" + this.getRow().getGenre());
        }
        cmds.add(String.valueOf(this.getProperties().getWavDir()) + File.separator + this.getRow().getFile());
        String[] array = new String[cmds.size()];
        int i = 0;
        while (i < cmds.size()) {
            array[i] = (String)cmds.get(i);
            ++i;
        }
        return array;
    }
}

