package org.shiftone.jrat.inject.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.shiftone.jrat.inject.Injector;
import java.io.File;

/**
 * @author $Author: jeffdrost $
 * @version $Revision: 1.20 $
 */
public class InjectTask extends AbstractFileTask {

	private Injector injector = null;

	private Injector getInjector() {

		if (injector == null) {
			injector = new Injector();
			// injector.setForceOverwrite(true);
		}
		return injector;
	}

	protected void processFile(File file) throws BuildException {

		log("processFile(" + file.getAbsolutePath() + ")", Project.MSG_VERBOSE);
		try {
			getInjector().inject(file);
		} catch (Exception e) {
			throw new BuildException(e);
		}
	}

	protected void validateFile(File file) throws BuildException {

		if (file.exists() == false) {
			throw new BuildException("File does not exist : " + file.getAbsolutePath());
		}
	}
}
