//
//  fountain.m
//  invadeus
//
//  Created by Christophe Degraeve on 13/10/11.
//

#import "fountain.h"

@implementation fountain

- (id)init
{
    self = [super init];
    if (self) {
        
        // Timer
        start = [NSDate date];
        [start retain];
        
        // Translate the camera.
        self.camera.position = iv3(0, 20, 5);
        [self.camera lookAt:0 y:0 z:0];

        
        // Ambient light
        [self setSceneAmbient:@"555555"];
        
        // Add a Light
        _light = [Isgl3dLight lightWithHexColor:@"FFFFFF" diffuseColor:@"FFFFFF" specularColor:@"FFFFFF" attenuation:0.2];  
        _light.position = iv3(0,2,2);
        [self.scene addChild:_light];
        
        
        // Generate fountain
        
        Isgl3dTextureMaterial *  spriteMaterial = [Isgl3dTextureMaterial materialWithTextureFile:@"star.png" shininess:0.9 precision:Isgl3dTexturePrecisionMedium repeatX:NO repeatY:NO];
        
		Isgl3dParticleSystem * particleSystem = [Isgl3dParticleSystem particleSystem];
		Isgl3dParticleNode * particleNode =  [self.scene createNodeWithParticle:particleSystem andMaterial:spriteMaterial];
		particleNode.transparent = YES;
		[particleNode enableAlphaCullingWithValue:0.5];
		[particleSystem setAttenuation:0.01 linear:0.02 quadratic:0.007];
		
		_fountainParticleGenerator = [[Isgl3dFountainBounceParticleGenerator alloc] initWithParticleSystem:particleSystem andNode:particleNode];
		_fountainParticleGenerator.radius = 15;
		_fountainParticleGenerator.height = 8;
		_fountainParticleGenerator.particleRate = 50;
		_fountainParticleGenerator.maxParticles = 400;
		_fountainParticleGenerator.randomizeColor = NO;
		_fountainParticleGenerator.randomizeSize = YES;
		_fountainParticleGenerator.size = 30;
		_fountainParticleGenerator.time = 2;
        
        [self schedule:@selector(tick:) ];

        started=1;
    }
    
    return self;
}


- (void) tick:(float)dt{
    
    if ([start timeIntervalSinceNow]<-118 && started==1) {
        // Animate!
        [_fountainParticleGenerator startAnimation];
        started=2;
    }
    if ([start timeIntervalSinceNow]<-160 && started==2) {
        // Desctruct the object
        [_fountainParticleGenerator setSelfDestructing:YES];
        started=3;
    }

}
@end


