//
//  foreground.m
//  invadeus
//
//  Created by Christophe Degraeve on 17/10/11.
//

#import "foreground.h"

@implementation foreground

- (id)init
{
    self = [super init];
    if (self) {
        // Timer
        start = [NSDate date];
        [start retain];
        
        delay = 7;
    
        
        // Translate the camera.
        self.camera.position = iv3(0, 20, 5);
        [self.camera lookAt:0 y:0 z:0];



        

    // Generate fountain
    
    Isgl3dTextureMaterial *  spriteMaterial = [Isgl3dTextureMaterial materialWithTextureFile:@"bubble.png" shininess:0.9 precision:Isgl3dTexturePrecisionMedium repeatX:NO repeatY:NO];
    
    particleSystem = [Isgl3dParticleSystem particleSystem];
    particleNode =  [self.scene createNodeWithParticle:particleSystem andMaterial:spriteMaterial];
    particleNode.transparent = YES;
    [particleNode enableAlphaCullingWithValue:0.5];
    [particleSystem setAttenuation:0.01 linear:0.02 quadratic:0.017];
    
    _fountainParticleGenerator = [[Isgl3dFountainBounceParticleGenerator alloc] initWithParticleSystem:particleSystem andNode:particleNode];
    _fountainParticleGenerator.radius = 15;
    _fountainParticleGenerator.height = 8;
    _fountainParticleGenerator.particleRate = 100;
    _fountainParticleGenerator.maxParticles = 200;
    _fountainParticleGenerator.randomizeColor = NO;
    _fountainParticleGenerator.randomizeSize = YES;
    _fountainParticleGenerator.size = 35;
    
    _fountainParticleGenerator.time = 2;

    destruct = 0;

        
        
    [self schedule:@selector(tick:) ];
    
}

return self;
}


- (void) tick:(float)dt{
    
    if ([start timeIntervalSinceNow]<-31 - delay && destruct == 0) {
        // Animate!
        [_fountainParticleGenerator startAnimation];
        destruct = 1;
    }
    

    
    if ([start timeIntervalSinceNow]<-35 - delay && destruct == 1) {
        // Destruct the object
        [_fountainParticleGenerator setSelfDestructing:YES];
        destruct = 2;
    }
    
}


@end
