//
//  invaderFirst.m
//  invadeus
//
//  Created by Christophe Degraeve on 11/09/11.
//

#import "invaderFirst.h"
#import "isgl3d.h"

@implementation invaderFirst

- (id)init
{
    self = [super init];
    if (self) {
        // Add a Light
        _light = [Isgl3dLight lightWithHexColor:@"FFFFFF" diffuseColor:@"FFFFFF" specularColor:@"FFFFFF" attenuation:0.2];  
        _light.position = iv3(0,2,2);
        
        [self.scene addChild:_light];
        
        // Timer
        invader_start = [NSDate date];
        [invader_start retain];
        
        delay = 62;
        
        // Set a size
        float size = 0.3;
    
        
        // Position
        int posY=0, posX=0;
        
        // Choose a nice material

        Isgl3dTextureMaterial * invader_cubeMaterial = [Isgl3dTextureMaterial materialWithTextureFile:@"invader.png"];
        
        // Construct the referential cube
        invader_cube = [Isgl3dCube meshWithGeometry:size height:size depth:size nx:2 ny:2];
        
        // Create a container for all nodes
        invader_container = [self.scene createNode];
        
        [self setSceneAmbient:@"555555"];
        
        // Construct the invader_matrix...  Nice to have a symetric alien :-)
        
        invader_matrix[7][4] = 0;
        invader_matrix[6][4] = 1;
        invader_matrix[5][4] = 1;
        invader_matrix[4][4] = 1;
        invader_matrix[3][4] = 1;
        invader_matrix[2][4] = 0;
        invader_matrix[1][4] = 0;
        invader_matrix[0][4] = 0;
        
        invader_matrix[7][3] = 0;
        invader_matrix[6][3] = 0;
        invader_matrix[5][3] = 0;
        invader_matrix[4][3] = 1;
        invader_matrix[3][3] = 1;
        invader_matrix[2][3] = 1;
        invader_matrix[1][3] = 0;
        invader_matrix[0][3] = 1;
        
        invader_matrix[7][2] = 1;
        invader_matrix[6][2] = 0;
        invader_matrix[5][2] = 1;
        invader_matrix[4][2] = 1;
        invader_matrix[3][2] = 1;
        invader_matrix[2][2] = 1;
        invader_matrix[1][2] = 1;
        invader_matrix[0][2] = 0;
        
        invader_matrix[7][1] = 0;
        invader_matrix[6][1] = 1;
        invader_matrix[5][1] = 1;
        invader_matrix[4][1] = 0;
        invader_matrix[3][1] = 1;
        invader_matrix[2][1] = 1;
        invader_matrix[1][1] = 0;
        invader_matrix[0][1] = 0;
        
        invader_matrix[7][0] = 0;
        invader_matrix[6][0] = 0;
        invader_matrix[5][0] = 1;
        invader_matrix[4][0] = 1;
        invader_matrix[3][0] = 1;
        invader_matrix[2][0] = 1;
        invader_matrix[1][0] = 0;
        invader_matrix[0][0] = 0;
                
        
        // Differential invader_matrix, yeah
        // Generate
        float x,y,revx;
        
        for (int c = 0; c < 5; c++) {
            x =  ((posX + c )* size) + size/2;
            revx =  ((posX - c)*size) - size/2 ;
                    
                    for (int r = 0; r < 8; r++) {
                            y = posY + r * size;
                        if (invader_matrix[r][c]==1) {
                            invader_cube_node[r][c] = [invader_container createNodeWithMesh:invader_cube andMaterial:invader_cubeMaterial ];
                            [invader_cube_node[r][c] translateByValues:x y:y z:0];
                            
                            invader_cube_node[r][c] = [invader_container createNodeWithMesh:invader_cube andMaterial:invader_cubeMaterial ];
                            [invader_cube_node[r][c] translateByValues:revx y:y z:0];
                            
                            
                        }

                    }
        }
        
         
        invader_container.z=0; 
        invader_container.y=-1;
        invader_container.x=-8;
        
        // Animate!
        
        invader_actionSequence = [Isgl3dActionSequence actionWithActions:
                                 [Isgl3dActionAlphaTo actionWithDuration:delay + 14.5 alpha:1],
                        
                        [Isgl3dActionRepeatForever actionWithAction: 
                        [Isgl3dActionSequence actionWithActions:
                         [Isgl3dActionParallel actionWithActions:
                          [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,-1.8,0)],
                          [Isgl3dActionEaseBounceInOut actionWithAction:
                            [Isgl3dActionScaleTo actionWithDuration:2 scale:2]]
                            ,nil],
                         [Isgl3dActionParallel actionWithActions:
                          [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,-1,0)],
                          [Isgl3dActionEaseBounceInOut actionWithAction:
                           [Isgl3dActionScaleTo actionWithDuration:2 scale:1]]
                            ,nil],
                          
                          nil 
                          ]],nil];
        

        
        // Retain, init start and hide
        [invader_actionSequence retain];

        
        invader_startup = 0;
        [invader_container setAlphaWithChildren:0];

        [invader_container runAction:invader_actionSequence];
        
        [self schedule:@selector(tick:) ];
        

    }
        
    return self;
}



- (void) tick:(float)dt{
   
    // Appear
    if ([invader_start timeIntervalSinceNow]<-(delay +1) && invader_startup==0) {
        
        [invader_container setAlphaWithChildren:1];
        invader_startup=1;
    } 
    // Disapear
    if ([invader_start timeIntervalSinceNow]<-(delay +65) && invader_startup==1) {
        [invader_container setAlphaWithChildren:0];
        invader_startup=2;
    } 
          
    // It comes in front of us
    if (invader_startup==1 && [invader_start timeIntervalSinceNow]>-(delay +14.5) ) {
        // Position
        invader_container.x += 0.01;
    }
    
    // Bye bye
    if (invader_startup==1 && [invader_start timeIntervalSinceNow]<-(delay +40)) {
        // Stop actions
        [invader_container stopAllActions];
        // Position
        invader_container.x += 0.01;
    }
    if (invader_startup==1){
        invader_container.rotationY += 3;
    }
}


@end
