//
//  invadeusAppDelegate.h
//  invadeus
//
//  Created by Christophe Degraeve on 11/09/11.
//


#import "invadeusAppDelegate.h"
#import "Isgl3dViewController.h"
#import "invaderFirst.h"
#import "movingCube.h"
#import "fountain.h"
#import "foreground.h"
#import "textView.h"


#import "Isgl3d.h"

@implementation invadeusAppDelegate

@synthesize window = _window;

- (void) applicationDidFinishLaunching:(UIApplication*)application {


    
    //Sound stuffs
    // *********************************************
    
    // Get the file path to the song to play.
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"Sound" 
                                                         ofType:@"m4a"];
    
    // Convert the file path to a URL.
    NSURL *fileURL = [[NSURL alloc] initFileURLWithPath:filePath];
    
    //Initialize the AVAudioPlayer.
    audioPlayer = [[AVAudioPlayer alloc] 
                   initWithContentsOfURL:fileURL error:nil];
    
    [audioPlayer play];

    // *********************************************
    
    
    
	// Create the UIWindow
	_window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	
    
	// Instantiate the Isgl3dDirector and set background color
	[Isgl3dDirector sharedInstance].backgroundColorString = @"000000ff"; 


    
	// Set the device orientation
	[Isgl3dDirector sharedInstance].deviceOrientation = Isgl3dOrientationLandscapeLeft;

	// Set the director to display the FPS
	[Isgl3dDirector sharedInstance].displayFPS = YES;  

	// Create the UIViewController
	_viewController = [[Isgl3dViewController alloc] initWithNibName:nil bundle:nil];
	_viewController.wantsFullScreenLayout = YES;
	
	// Create OpenGL view (here for OpenGL ES 1.1)
	Isgl3dEAGLView * glView = [Isgl3dEAGLView viewWithFrameForES1:[_window bounds]];

	// Set view in director
	[Isgl3dDirector sharedInstance].openGLView = glView;
	
	// Specify auto-rotation strategy if required (for example via the UIViewController and only landscape)
	[Isgl3dDirector sharedInstance].autoRotationStrategy = Isgl3dAutoRotationByUIViewController;
	[Isgl3dDirector sharedInstance].allowedAutoRotations = Isgl3dAllowedAutoRotationsLandscapeOnly;
	
	// Enable retina display : uncomment if desired
	[[Isgl3dDirector sharedInstance] enableRetinaDisplay:NO];

	// Enables anti aliasing (MSAA) : uncomment if desired (note may not be available on all devices and can have performance cost)
	[Isgl3dDirector sharedInstance].antiAliasingEnabled = NO;
	
	// Set the animation frame rate
	[[Isgl3dDirector sharedInstance] setAnimationInterval:1.0/60];

	// Add the OpenGL view to the view controller
	_viewController.view = glView;

	// Add view to window and make visible
	[_window addSubview:_viewController.view];
	[_window makeKeyAndVisible];

	// Creates the view(s) and adds them to the director
    [[Isgl3dDirector sharedInstance] addView:[movingCube view]];
    [[Isgl3dDirector sharedInstance] addView:[invaderFirst view]];
    [[Isgl3dDirector sharedInstance] addView:[fountain view]];
    [[Isgl3dDirector sharedInstance] addView:[foreground view]];
    [[Isgl3dDirector sharedInstance] addView:[textView view]];

    
	// Run the director
	[[Isgl3dDirector sharedInstance] run];
    

    
}

- (void) dealloc {
	if (_viewController) {
		[_viewController release];
	}
	if (_window) {
		[_window release];
	}
	
	[super dealloc];
}

- (void) applicationWillResignActive:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] pause];
}

- (void) applicationDidBecomeActive:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] resume];
}

- (void) applicationDidEnterBackground:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] stopAnimation];
}

- (void) applicationWillEnterForeground:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] startAnimation];
}

- (void) applicationWillTerminate:(UIApplication *)application {
	// Remove the OpenGL view from the view controller
	[[Isgl3dDirector sharedInstance].openGLView removeFromSuperview];
	
	// End and reset the director	
	[Isgl3dDirector resetInstance];
	
	// Release
	[_viewController release];
	_viewController = nil;
	[_window release];
	_window = nil;
}

- (void) applicationDidReceiveMemoryWarning:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] onMemoryWarning];
}

- (void) applicationSignificantTimeChange:(UIApplication *)application {
	[[Isgl3dDirector sharedInstance] onSignificantTimeChange];
}

@end
