//
//  movingCube.m
//  invadeus
//
//  Created by Christophe Degraeve on 03/10/11.
//

#import "movingCube.h"

@implementation movingCube

- (id)init
{
    self = [super init];
    if (self) {
        // Timer
        start = [NSDate date];
        [start retain];
        
        delay = 7;
        
        
        // Camera
        self.camera.zoom = 1.5;
        
        // Ambient light
        [self setSceneAmbient:@"555555"];
        
        // Add a Light
        _light = [Isgl3dLight lightWithHexColor:@"FFFFFF" diffuseColor:@"FFFFFF" specularColor:@"FFFFFF" attenuation:0.2];  
        _light.position = iv3(0,2,2);

        [self.scene addChild:_light];
        
    
        
        // Create containers for all nodes
        _container = [self.scene createNode];
        _container2 = [self.scene createNode];
        
        // Choose a nice material
        
        Isgl3dTextureMaterial * material1 = [Isgl3dTextureMaterial materialWithTextureFile:@"cube.png"];
        Isgl3dTextureMaterial * material2 = [Isgl3dTextureMaterial materialWithTextureFile:@"sphere.png"];
        Isgl3dTextureMaterial * material3 = [Isgl3dTextureMaterial materialWithTextureFile:@"background1.png"];

        // Construct the referential plane
        face = [Isgl3dPlane meshWithGeometry:1 height:1 nx:1 ny:1];
        
        // Let the matrix shines 
        matrix[0][0]=-0.5; // position X
        matrix[0][1]=0; // position Y
        matrix[0][2]=0; // position Z
        matrix[0][3]=0; // rotation X
        matrix[0][4]=-90; // rotation Y
        matrix[0][5]=0; // rotation Z
        matrix2[0]=3; // action #
        
        matrix[1][0]=0.5; // position X
        matrix[1][1]=0; // position Y
        matrix[1][2]=0; // position Z
        matrix[1][3]=0; // rotation X
        matrix[1][4]=90; // rotation Y
        matrix[1][5]=0; // rotation Z
        matrix2[1]=0; // action #
        
        matrix[2][0]=0; // position X
        matrix[2][1]=0; // position Y
        matrix[2][2]=-0.5; // position Z
        matrix[2][3]=0; // rotation X
        matrix[2][4]=0; // rotation Y
        matrix[2][5]=0; // rotation Z
        matrix2[2]=5; // action #
        
        matrix[3][0]=0; // position X
        matrix[3][1]=0; // position Y
        matrix[3][2]=0.5; // position Z
        matrix[3][3]=0; // rotation X
        matrix[3][4]=0; // rotation Y
        matrix[3][5]=0; // rotation Z
        matrix2[3]=2; // action #
        
        matrix[4][0]=0; // position X
        matrix[4][1]=0.5; // position Y
        matrix[4][2]=0; // position Z
        matrix[4][3]=-90; // rotation X
        matrix[4][4]=0; // rotation Y
        matrix[4][5]=0; // rotation Z
        matrix2[4]=1; // action #
        
        matrix[5][0]=0; // position X
        matrix[5][1]=-0.5; // position Y
        matrix[5][2]=0; // position Z
        matrix[5][3]=90; // rotation X
        matrix[5][4]=0; // rotation Y
        matrix[5][5]=0; // rotation Z
        matrix2[5]=4; // action #

        // Start opening in seconds
        int numberOfSeconds = delay + 20;
        
        // Action stuffs
        actionSequence[0] =[Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                         [Isgl3dActionSequence actionWithActions:
                          [Isgl3dActionEaseBounceInOut actionWithAction:
                           [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(1,0,0)]],
                          [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(1,0,0)],
                          [Isgl3dActionEaseBounceInOut actionWithAction:
                           [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0.5,0,0)]],
                          
                          [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(0.5,0,0)],
                          nil 
                          ]],nil];
        
        actionSequence[1] =[Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,1,0)]],
                             [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,1,0)],
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0.5,0)]],
                             
                             [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(0,0.5,0)],
                             nil 
                             ]],nil];
        
        actionSequence[2] =[Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,1)]],
                             [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,1)],
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,0.5)]],
                             
                             [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(0,0,0.5)],
                             nil 
                             ]],nil];
        
        actionSequence[3] = [Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(-1,0,0)]],
                             [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(-1,0,0)],
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(-0.5,0,0)]],
                             
                             [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(-0.5,0,0)],
                             nil 
                             ]],nil];
        
        actionSequence[4] = [Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,-1,0)]],
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,-1,0)],
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,-0.5,0)]],
                             
                             [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(0,-0.5,0)],
                             nil 
                             ]],nil];
        
        actionSequence[5] = [Isgl3dActionSequence actionWithActions:
                            [Isgl3dActionAlphaTo actionWithDuration:numberOfSeconds alpha:1],
                            [Isgl3dActionRepeatForever actionWithAction: 
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,-1)]],
                             [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,-1)],
                             [Isgl3dActionEaseBounceInOut actionWithAction:
                              [Isgl3dActionMoveTo actionWithDuration:2 position:iv3(0,0,-0.5)]],
                             
                             [Isgl3dActionMoveTo actionWithDuration:4 position:iv3(0,0,-0.5)],
                             nil 
                             ]],nil];

        
        actionSequence[6] = [Isgl3dActionRepeatForever actionWithAction:
                            [Isgl3dActionSequence actionWithActions:
                             [Isgl3dActionRollBy actionWithDuration:10 angle:-360]
                             ,nil]
                              ];
        
        actionSequence[7] = [Isgl3dActionAlphaTo actionWithDuration:5 alpha:0];
        
        [actionSequence[7] retain];
        
        for (int c = 0; c < 6; c++) {
        
            // Construct the cube
            cube_node[c]=[_container createNodeWithMesh:face andMaterial:material1];
            cube_node[c].x= matrix[c][0];
            cube_node[c].y= matrix[c][1];
            cube_node[c].z= matrix[c][2];
            cube_node[c].rotationX= matrix[c][3];
            cube_node[c].rotationY= matrix[c][4];
            cube_node[c].rotationZ= matrix[c][5];
            cube_node[c].doubleSided = YES;
            
            // Action!
            [cube_node[c] runAction:actionSequence[matrix2[c]]];
      
            
        }    
        
        
        // Background
        face2 = [Isgl3dPlane meshWithGeometry:12 height:12 nx:1 ny:1];
        background=[_container2 createNodeWithMesh:face2 andMaterial:material3];
        background.z = -2;
        [background runAction:actionSequence[6]];

        
        // Construct the sphere
        sphere = [Isgl3dSphere meshWithGeometry:0.3 longs:50 lats:50];
        sphere_node=[_container createNodeWithMesh:sphere andMaterial:material2];

        
        // Startup init and set position
        startup = 0;
        [_container setPositionValues:-3.5 y:0 z:0];
        
        [self schedule:@selector(tick:) ];
            
    }
   
    
    return self;
}





- (void) tick:(float)dt{
    
    
    // Appear
    if ([start timeIntervalSinceNow]<-(0 + delay) && startup==0) {
        startup=1;
    } 
    
    // Disapear
    if ([start timeIntervalSinceNow]<-(60 + delay) && startup==1) {
        startup=2;
    } 
    
    // Background Disapear
    if ([start timeIntervalSinceNow]<-163) {
        [background runAction:actionSequence[7]];
    }
    
    // It comes...
    if (startup==1 && [start timeIntervalSinceNow]>-(15 + delay) ) {
        // Position
        _container.x += 0.0038;
    }
    
    // And... Bye bye
    if (startup==1 && [start timeIntervalSinceNow]<-(40 + delay)) {
        // Position
        _container.x += 0.004;
    }
    
    // Rotation
    if ([start timeIntervalSinceNow]<-(0 + delay)) {
        // Rotate
        _container.rotationY += 2;
        _container.rotationX += 2;

    }
    
}

@end
