
const float steps = 20.0;

uniform sampler2D depthtex;
uniform sampler2D colortex;
uniform sampler2D noise;
uniform float t;
uniform float ballsize;
uniform float darken;


void main() {
	vec3 pos = vec3(gl_TexCoord[0].xy, texture2D(depthtex, gl_TexCoord[0].xy).x);
	float bri = 1.0;
	vec2 xy = (gl_TexCoord[0].xy+vec2(t,t))*4.11;

	for (float i = 0.0; i < steps; i += 1.0) {
		vec4 rand = normalize(-1.0+2.0*texture2D(noise, xy));
		vec3 ray = normalize(rand.xyz)*rand.a*ballsize;
		float nz = texture2D(depthtex, pos.xy+ray.xy/pos.z).r;

		if (nz < pos.z) {
			bri -= 1.0/steps*darken;
		}

		xy.x += 0.04;
		xy.y += 0.03;
	}


	vec4 col = texture2D(colortex, gl_TexCoord[0].xy);
	gl_FragColor.a = bri;
}

