
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new velocity
  float4 rt2 : COLOR2; // 
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;
float g_timeStep;


texture g_tNoise;
sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = WRAP;
  AddressV = WRAP;
};

texture g_tPosPrev;
sampler smPosPrev =
sampler_state {
  Texture = <g_tPosPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVelPrev;
sampler smVelPrev =
sampler_state {
  Texture = <g_tVelPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVarPrev;
sampler smVarPrev =
sampler_state {
  Texture = <g_tVarPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

float2 indexToCoords(float index, float width) {
  float2 tc;


  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float coordsToIndex(float2 tc, float2 dim) {
  return tc.x*dim.x + (int)(tc.y*dim.y)*dim.x;
}

float4 turb(sampler s, float2 tc, int fr) {
  float4 r = float4(0.0, 0.0, 0.0, 0.0);
  float m = 0.50;
  for (int i=0; i<fr; i++) {
    r += (tex2D(s, tc)*2.0-1.0)*m;
    tc *= 2.0;
    m *= 0.5;
  }
  return r;
}

  float g_floorLevel;
  float g_collisionAtt;


PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float2 tcOfs = float2((+0.5)/g_windowWidth, (+0.5)/g_windowHeight);
  float4 pos = tex2D(smPosPrev, In.vTexcoord+tcOfs);
  float4 vel = tex2D(smVelPrev, In.vTexcoord+tcOfs);
  float4 var = tex2D(smVarPrev, In.vTexcoord+tcOfs);
  
  float pixIndex = coordsToIndex(In.vTexcoord, float2(g_windowWidth, g_windowHeight)); 

  
  int bInit = 0;
  
  float4 grav = float4(0.0, -90.00, 0.0, 0.0);
  
  pos.w = pos.w - g_timeStep;

  if (pos.w < 0.01) { //  || pos.y < -30.0) {
    bInit = 1;
  } 

//  float4 noise = tex2D(smNoise,pos.xy*0.001)*2.0-1.0;
//  float4 noise = turb(smNoise, (pos.xy*0.12321+pos.z*0.13134)*0.001+g_time*float2(0.023, 0.011345)*0.00, 1);
  float4 noise = turb(smNoise, (pos.xy*0.12321+pos.z*0.13134)*0.1+g_time*float2(0.023, 0.011345)*0.00, 1);

 // vel.xyz += 0.020*(3.0+2500.0*saturate(sin(pixIndex*0.001+g_time*16.0)))*noise.xyz*g_timeStep;
  vel.xyz += 80.0*noise.xyz*g_timeStep;

 // vel *= 0.9999;


  vel.w += 0.1*(1.57+atan(vel.y/(vel.z))-vel.w);

  vel.xyz += grav.xyz*g_timeStep;
  pos.xyz += vel.xyz*g_timeStep;


  if (pos.y < -g_floorLevel && vel.y < 0.0) {
    diff = -g_floorLevel-pos.y;
    pos.y += diff;
    vel.y *= -g_collisionAtt;
  }

  if (pos.y > g_floorLevel && vel.y > 0.0) {
    diff = pos.y - g_floorLevel;
    pos.y -= diff;
    vel.y *= -g_collisionAtt;
  }
  
  
  if (bInit) {

    float4 result;
    float pf;
    
    pf = pixIndex*1.232321;

    float2 tc = indexToCoords(pixIndex+g_time*15342.5543, g_windowWidth);

/*

    result.x = sin(7.7678*cos(pf*1.2348+g_time*0.01))*1.0;
    result.y = cos(6.28954*sin(pf*1.41243+0.012*g_time))*1.0;
    result.z = sin(pf*1.2442135+0.014*g_time)*1.0;
*/
    float4 noise2 = tex2D(smNoise, tc)*2.0-1.0;
    float4 noisePos = tex2D(smNoise, g_time*float2(1.234, 2.32325)*0.001)*2.0-1.0;
    result = noise2;

   // result.y = 0.0;

  //  result.
    result.xz = In.vTexcoord;
    result.xz -= 0.5;

   // result.x *= 0.4;
    result.y = 0.0;


   // result = tex2D(smNoise, In.vTexcoord+tcOfs+indexToCoords(pixIndex+g_time))*2.0-1.0;
    result *= 2.0;


    pf = 0.0; // pixIndex*0.001;

    /*
    result.x += sin(g_time*2.21)*20.0;
    result.y += 70.0;
    result.z += cos(g_time*2.21)*20.0;
*/
    result.w = 1.0;

    vel.xyz = noise2.xyz*3.0;
    vel.y += 24.0;

    int pixIndexI = (int)(pixIndex*0.001);

   // pos = float4(0.0+frac(pixIndex*0.01)*1.0, -20.0+frac(pixIndex*0.02345)*1.0, 0.0, 2.0+(float)pixIndex*2.0/10000.0);
    pos = float4(result.x, -70.0+result.y, result.z, 5+noise2.z*5.0);
    pos.xz += noisePos.xz*350.0;
   // pos = float4(0.0, -20.0, 0.0, 2.0+(float)pixIndex*2.0/1000.0);

    var = float4(2.0, 0.0, 0.0, 1.0); // time to live
  }
    
  
  o.rt0 = pos;
  o.rt1 = vel;
  o.rt2 = var;
  
  return o;
} 



technique Render {
    pass P0 {          
        VertexShader = compile vs_2_a vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

