#include "shared.inc"

sampler TexDiffuse	: register(s0);
sampler TexNormal	: register(s1);
sampler TexSpecular	: register(s2);
sampler TexGloss	: register(s3);
sampler TexEmissive	: register(s4);

//------------------------------------------------------------------------
void vs(
	float4 position 		: POSITION,
	float2 uv				: TEXCOORD0,
	float3 normal			: NORMAL,
	float3 tangent			: TANGENT,
	float3 binormal			: BINORMAL,
					  
	out float4 oPosition	: POSITION,
	out float3 oUvTime		: TEXCOORD0,	
	out float3 oToEye		: TEXCOORD1,
	out float3 oTangentsX	: TEXCOORD2, // tangent-space: tangent
	out float3 oTangentsY	: TEXCOORD3, // tangent-space: binormal
	out float3 oTangentsZ	: TEXCOORD4, // tangent-space: normal
	out float4 oColor		: COLOR,

	uniform float4x4	worldViewProj,
	uniform float4x4	world,
	uniform float4		eye,
	uniform float4		ambient,
	uniform float		time,
	uniform float4		lightPosition)
{
	oPosition = mul(worldViewProj, position);
	
	float4 worldPos = mul(world, position);
	oToEye = eye.xyz - worldPos.xyz;
	oUvTime = float3(uv, time);
	oColor = ambient;

	// rotate object-space tangent-space to world
	oTangentsX = mul((float3x3)world, tangent.xyz);
	oTangentsY = mul((float3x3)world, binormal.xyz);
	oTangentsZ = mul((float3x3)world, normal.xyz);
}

//------------------------------------------------------------------------
float4 fs(
	float3 texCoordTime	: TEXCOORD0, 
	float3 toEye		: TEXCOORD1,
	float3 tangentsX	: TEXCOORD2, // tangent-space: tangent
	float3 tangentsY	: TEXCOORD3, // tangent-space: binormal
	float3 tangentsZ	: TEXCOORD4, // tangent-space: normal
	float4 vertexColor	: COLOR ) : COLOR
{
	const float2 uv = texCoordTime.xy;
	const float time = texCoordTime.z;

	float3 tangentNormal 		= ExpandTextureNormal( tex2D(TexNormal, uv).xyz );
	float3 worldNormal			= TransformToWorldNormal( tangentNormal, tangentsX, tangentsY, tangentsZ );

	float4 diffuseMapSample		= tex2D( TexDiffuse, uv );
	float3 albedo				= Ungamma( diffuseMapSample.rgb );
	float3 specularColor		= Ungamma( tex2D( TexSpecular, uv ).rgb );
	float glossinessSample		= tex2D( TexGloss, uv ).r;
	
	float atten = torch_atten(toEye);
	float3 lightDir = torch_dir(toEye, time);
	const float diffuseCoeff = max( 0.f, dot(worldNormal, normalize(lightDir)) );
	
	const float lightSpecularIntensity = 1.f;
	float specularPower = 0.001f + glossinessSample*glossinessSample*100.f;
	float3 worldToEyeDir = normalize( toEye.xyz );
	float3 specularHalf = normalize( lightDir + worldToEyeDir );
	float specularCoeff = pow(max(0.f,dot(specularHalf, worldNormal)), specularPower);
	specularCoeff *= lightSpecularIntensity;
	
	float3 lightColor = torch_light(time);
	
	float4 color;
	color.rgb = Gamma( atten*diffuseCoeff*albedo*lightColor + atten*specularCoeff*specularColor );
	color.a = diffuseMapSample.a;
	return color;
}

