function activate_state(state)
	active_state:deactivate()
	active_state = state
	active_state:activate()
end

move_state =
{
	actions =
	{
		[keys.up] = function()
			if dungeon_master:Move( 1, 0 ) then
				activate_state( moving_state )
			end
		end,
		[keys.down] = function()
			if dungeon_master:Move( -1, 0 ) then
				activate_state( moving_state )
			end
		end,
		[keys.q] = function()
			if dungeon_master:Move( 0, 1 ) then
				activate_state( moving_state )
			end
		end,		
		[keys.e] = function()
			if dungeon_master:Move( 0, -1 ) then
				activate_state( moving_state )
			end
		end,			
		[keys.right] = function()
			dungeon_master:Turn( 1 )
		end,
		[keys.left] = function()
			dungeon_master:Turn( -1 )
		end
	},
	activate = function(self)
		move_ui.Visible = true
	end,
	deactivate = function(self)
		move_ui.Visible = false
	end,
	update = function(self, dt)
		local isSomeoneAlive = false
		for i, v in ipairs( party ) do
			if v.HP <= 0 then
				attack_button[i].Visible = false
				attack_button_on_cooldown[i].Visible = true
			end
			if v.MeleeCooldown > 0 then
				v.MeleeCooldown = v.MeleeCooldown - dt
				if v.MeleeCooldown <= 0 then
					v.MeleeCooldown = 0
					if v.HP > 0 then
						attack_button[i].Visible = true
						attack_button_on_cooldown[i].Visible = false
					end
				end
			end
			isSomeoneAlive = isSomeoneAlive or (v.HP > 0)
		end
		
		if not isSomeoneAlive then
			activate_state( end_state )
		end
		
		-- update hp texts
		for i, v in ipairs( hp_texts ) do
			local hp = party[i].HP
			local max_hp = party[i].MaxHP
			if hp < 0 then
				v.Text = party[i].Name .. "\n-Dead-"
				portraits_dead[i].Visible = true
			elseif hp == 0 then
				v.Text = party[i].Name .. "\n-Dying-"
				portraits_dead[i].Visible = false
			else
				v.Text = party[i].Name .. "\n" .. hp .. " of " .. max_hp
				portraits_dead[i].Visible = false
			end
		end
		
		dungeon_master:Update(dt, update)

		if dungeon_master:IsLevelExit() then
			if level < num_levels then
				-- use intro state as cutscene
				activate_state( intro_state )
			else
				activate_state( complete_state )
			end
		end
	end,
	music = create_music( "Data/Audio/bjorn__lynne-_the_alchemist.mid" ),
}
move_state.actions[keys.w] = move_state.actions[keys.up]
move_state.actions[keys.s] = move_state.actions[keys.down]
move_state.actions[keys.d] = move_state.actions[keys.right]
move_state.actions[keys.a] = move_state.actions[keys.left]

moving_state =
{
	actions =
	{
	},
	activate = function(self)
		if math.random() < 0.1 then
			--activate_state( intro_state )
			activate_state( move_state )
		else
			activate_state( move_state )
		end
	end,
	deactivate = function(self)
	end,
	update = function(self, dt)
	end,
}

combat_state =
{
	actions =
	{
		[keys.enter] = function()
			Info( "*** COMBAT ENDS! ***" )
			activate_state( move_state )
		end,
	},
	activate = function(self)
		Info( "*** COMBAT BEGINS! - Press enter to exit ***" )
	end,
	deactivate = function(self)
	end,
	update = function(self, dt)
	end,
}

titlescreen_state =
{
	actions =
	{
		[keys.anykey] = function()
			activate_state( intro_state )
		end,
	},
	activate = function(self)
		intro_text.Text = level_texts.titlescreen()
		intro_ui.Visible = true
	end,
	deactivate = function(self)
		level = 0
		intro_ui.Visible = false
	end,
	update = function(self, dt)
		dungeon_master:IntroUpdate(dt)
	end,
	music = create_music( "Data/Audio/bjorn__lynne-_ye_olde_inn.mid" ),
}

intro_state =
{
	actions =
	{
		[keys.anykey] = function()
			activate_state( move_state )
		end,
	},
	activate = function(self)
		add_party_member()
		intro_text.Text = level_texts[level + 1]()
		intro_ui.Visible = true
		if level ~= 0 then
			play_sfx( sfx.level_end )
		end
	end,
	deactivate = function(self)
		level = level + 1
		intro_ui.Visible = false
		dungeon_master:ClearLevel()
		dungeon_master:CreateLevelBlocksFromString( levels[level] )
		play_sfx( sfx.level_begin )
		rest_party()
	end,
	update = function(self, dt)
		dungeon_master:IntroUpdate(dt)
	end,
	music = create_music( "Data/Audio/bjorn__lynne-_ye_olde_inn.mid" ),
}

complete_state =
{
	actions =
	{
	},
	activate = function(self)
		add_party_member() -- call just in case someone wants to test with fewer levels
		intro_text.Text = level_texts[level + 1]()
		intro_ui.Visible = true
		play_sfx( sfx.level_end )
	end,
	deactivate = function(self)
	end,
	update = function(self, dt)
		dungeon_master:IntroUpdateComplete(dt)
	end,
	music = create_music( "Data/Audio/bjorn__lynne-_the_heroes_return.mid" ),
}

end_state =
{
	actions =
	{
		[keys.anykey] = function()
			dungeon_master:Exit()
		end,
	},
	activate = function(self)
		intro_text.Text = level_texts.GameOver()
		intro_ui.Visible = true
	end,
	deactivate = function(self)
	end,
	update = function(self, dt)
		dungeon_master:IntroUpdate(dt)
	end,
	music = create_music( "Data/Audio/bjorn__lynne-_in_reverence.mid" ),
}

--active_state = move_state
active_state = titlescreen_state
titlescreen_state:activate()
