ui = Construct( "TScene", "Panel" )
ui.Position = { x=0, y=0 }
ui.Size = { x=1920, y=1080 }
ui.ChildDimensions = { x=1920, y=1080 }
--ui.Texture = "Overlay_Background"

-- Move state UI
move_ui = Construct( "TScene", "Panel" )
move_ui.Position = { x=0, y=0 }
move_ui.Size = { x=1920, y=1080 }
move_ui.ChildDimensions = { x=1920, y=1080 }
move_ui.Texture = "Overlay_Background"
move_ui.Visible = false
ui:AddWidget( move_ui )

-- Portraits
portraits = {}
hp_texts = {}
portraits_dead = {}
function update_portraits()
	for i = #portraits + 1, #party do
		local p = Construct( "TScene", "Button" )
		p.Position 	= { x=1750, y=60+(i-1)*160 }
		p.Size		= { x=128, y=150 }
		p.Texture	= party[i].Portrait
		move_ui:AddWidget( p )
		
		local d = Construct( "TScene", "Button" )
		d.Position 	= { x=1750, y=60+(i-1)*160 }
		d.Size		= { x=128, y=150 }
		d.Texture	= "Portrait_Skull"
		d.Visible	= false
		move_ui:AddWidget( d )
		
		local t = Construct( "TScene", "Label" )
		t.Font = "HpFont"
		t.FontHeight = 0.03
		t.Position = { x=1750-8, y=60+(i-1)*160+150*3/4 }
		t.TextAlign = t.ALIGN_RIGHT
		move_ui:AddWidget(t)
		
		table.insert( portraits, p )
		table.insert( portraits_dead, d )
		table.insert( hp_texts, t )
	end
end

-- UI handler
function on_button_pressed(self, button)
	for i, v in ipairs( attack_button ) do
		if v == button then
			member = party[i]
			local damage = member:MeleeDamage()
			local result = dungeon_master:MeleeAttack(damage)
			if result == 0 then
				dungeon_master:Info(member.Name .. " swings " .. member.Weapon .. " madly!")
				play_sfx( sfx[member.MeleeSound] )
			elseif result == 1 then
				dungeon_master:Info(member.Name .. " hits Will-o'-wisp for " .. damage .. " points with " .. member.Weapon .. "!");
				play_sfx( sfx[member.MeleeSound] )
				play_sfx( sfx.hit )
			elseif result == 2 then
				dungeon_master:Info(member.Name .. " hits Will-o'-wisp for " .. damage .. " points and kills it with " .. member.Weapon .. "!");
				play_sfx( sfx[member.MeleeSound] )
				play_sfx( sfx.hit )
			end
			
			-- put the button on cooldown
			party[i].MeleeCooldown = party[i].MeleeSpeed
			button.Visible = false
			attack_button_on_cooldown[i].Visible = true
		end
	end
end

local uihandler_class = Construct( "TBase", "ClassInfoTable" )
uihandler_class.BaseClass = GetModuleTable().TBase.Object
uihandler_class:Insert( "OnButtonPressed", on_button_pressed )

uihandler = Construct( "TBase", "Object" )
uihandler:SetInstanceTable( uihandler_class )

-- Buttons
attack_button = {}
attack_button_on_cooldown = {}
function update_buttons()
	for i = #attack_button + 1, #party do
		local button = Construct( "TScene", "Button" )
		button.Position 		= { x=1700, y=100+(i-1)*160 }
		button.Size 			= { x=64, y=64 }
		button.Texture			= "Button_Sword"
		button.TexturePressed	= "Button_Sword_Pressed"
		button.EventHandler		= uihandler
		move_ui:AddWidget( button )
		table.insert( attack_button, button )

		local cooldownButton = Construct( "TScene", "Button" )
		cooldownButton.Position 		= button.Position
		cooldownButton.Size 			= button.Size
		cooldownButton.Texture			= "Button_Sword_Cooldown"
		cooldownButton.Visible			= false
		move_ui:AddWidget( cooldownButton )
		table.insert( attack_button_on_cooldown, cooldownButton )
	end
end

serializer = Construct( "TBase", "FileSerializer")
intro_ui = serializer:Deserialize("Script/IntroUI.TXmlObject")
intro_text = intro_ui.Children[0]
ui:AddWidget( intro_ui )