#ifdef GL_ES
precision highp float;
#endif

uniform float time;
varying vec4 pos;

uniform sampler2D uSampler;

uniform sampler2D chica2Tex;
uniform sampler2D balloonTex;

vec4 drawBalloon(vec4 c, vec2 coord, vec2 center, float scale, float ttime) {
	vec2 girlcoord;
	vec4 col;

	vec4 bounds = vec4(center.x - 0.125*scale, center.y - 0.125*scale*(16.0/9.0), center.x + 0.125*scale, center.y + 0.125*scale*(16.0/9.0));
	if (coord.x > bounds.x && coord.y > bounds.y && coord.x < bounds.z && coord.y < bounds.w) {
		girlcoord.y = (coord.y - bounds.y) / (bounds.w - bounds.y);
		girlcoord.x = (coord.x - bounds.x) / (bounds.z - bounds.x);
		col = texture2D(balloonTex, girlcoord);
		if (time < 20.0) {
			col.a *= max(0.0, 1.0 - ttime*0.7);
		}
		if (ttime > 23.0) {
			if (girlcoord.y < 0.77) col.a = 0.0;
		}
		col = mix(c, col, col.a);
		
		return col;
	}
	
	return c;
}

vec4 drawGirl(vec4 c, vec2 coord, vec2 center, float scale, float aa) {
	vec2 girlcoord;
	
	vec4 col;
	vec4 col2;
	vec4 bounds = vec4(center.x - 0.125*scale, center.y - 0.125*scale*(16.0/9.0), center.x + 0.125*scale, center.y + 0.125*scale*(16.0/9.0));
	if (coord.x > bounds.x && coord.y > bounds.y && coord.x < bounds.z && coord.y < bounds.w) {
		girlcoord.y = (coord.y - bounds.y) / (bounds.w - bounds.y);
		girlcoord.x = (coord.x - bounds.x) / (bounds.z - bounds.x);
		if (time < 19.2)
			col = texture2D(chica2Tex, girlcoord);
		else 
			col = vec4(0.0);
		if (time < 16.8) {
			col2 = texture2D(balloonTex, girlcoord);
			//girlcoord.y -= (time -16.8)*0.5;
		} else
			col2 = vec4(0.0);
		
		//alpha blending
		if (time < 16.8) {
			col = mix(c, col, col.a);
			col = mix(col, col2, col2.a);
			col = mix(c, col, aa);
		} else {
			col = mix(c, col, col.a);
			col = mix(c, col, aa);			
			col = mix(col, col2, col2.a);
		}
		return col;
	}	

	return c;
}

vec4 drawGirl2(vec4 c, vec2 coord, vec2 center, float scale, float aa) {
	vec2 girlcoord;
	
	vec4 col;
	vec4 col2;
	vec4 bounds = vec4(center.x - 0.125*scale, center.y - 0.125*scale*(16.0/9.0), center.x + 0.125*scale, center.y + 0.125*scale*(16.0/9.0));
	if (coord.x > bounds.x && coord.y > bounds.y && coord.x < bounds.z && coord.y < bounds.w) {
		girlcoord.y = (coord.y - bounds.y) / (bounds.w - bounds.y);
		girlcoord.x = (coord.x - bounds.x) / (bounds.z - bounds.x);
		col = texture2D(chica2Tex, girlcoord);
		
		col = mix(c, col, col.a);
		col = mix(c, col, aa);
		
		return col;
	}	

	return c;
}

void main(void) {
	float t = time/60.0;
	vec4 color;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);
	float rikkomus;
	
	const int SOBELNUM = 9;
	const float kerroin = 0.007;
	
	if (time > 49.5) {
		rikkomus = mix(0.0, 0.1, min(1.0, (time - 49.5)*0.5));		
	} else if (time > 44.8) {
		rikkomus = mix(0.0055, 0.0015, min(1.0, time - 44.8));
	} else {
		rikkomus = 0.0055;
	}
	
	vec2 c[SOBELNUM];
	c[0] = vec2(-kerroin, kerroin);
	c[1] = vec2(0.0, kerroin);
	c[2] = vec2(kerroin, kerroin);
	c[3] = vec2(-kerroin, 0.0);
	c[4] = vec2(0.0, 0.0);
	c[5] = vec2(kerroin, 0.0);
	c[6] = vec2(-kerroin, -kerroin);
	c[7] = vec2(0.0, -kerroin);
	c[8] = vec2(kerroin, -kerroin);
	
	vec3 col[SOBELNUM];
	float lum[SOBELNUM];
	int i;
	
	vec3 rgb2lum = vec3(0.30, 0.59, 0.11);
	
	for (int i=0; i < SOBELNUM; i++) {
		col[i] = texture2D(uSampler, coord + c[i]).rgb;
		lum[i] = dot(col[i], rgb2lum);
	}
	
	float x = lum[2]+  lum[8]+2.0*lum[5]-lum[0]-2.0*lum[3]-lum[6];
	float y = lum[6]+2.0*lum[7]+  lum[8]-lum[0]-2.0*lum[1]-lum[2];
	
	vec2 bindit = coord + vec2(x, y)*rikkomus;
	bindit.x = min(0.9999999, max(0.0, bindit.x));
	bindit.y = min(0.9999999, max(0.0, bindit.y));
	color.rgba = texture2D(uSampler, bindit).rgba;

	if (time > 13.2 && time < 14.3)
		color = drawGirl(color, coord, vec2(0.36, 0.46), 0.5, sin((time-13.2)*3.0));
	if (time > 14.4 && time < 15.5)
		color = drawGirl(color, coord, vec2(0.95, 0.43), 0.75, sin((time-14.4)*2.7));
	if (time > 15.6 && time < 25.0)
		color = drawGirl(color, coord, vec2(0.28, 0.2), 1.0, sin((time-15.6)*0.85));
	if (time > 16.8 && time < 19.00)
		color = drawBalloon(color, coord, vec2(0.28+(time-16.8)*0.1, 0.2+(time-16.8)*0.5), 1.0 - (time-16.8)*0.3, time-16.8);
		
	if (time > 35.0)
		color = drawBalloon(color, coord, mix(vec2(-0.05, -0.05), vec2(0.55, 0.4), min(1.0, (time-35.5)/1.5)), 1.0 - max(0.0, min(1.0, (time-36.8))), time);		

	if (time > 25.6 && time < 29.0)
		color = drawGirl2(color, coord, vec2(0.18, 0.36), 0.7, sin((time-25.6)*0.9));

	if (time > 28.0 && time < 30.8)
		color = drawGirl2(color, coord, vec2(0.32, 0.42), 0.25, sin((time-28.0)*1.1));

	if (time > 29.3 && time < 31.9)
		color = drawGirl2(color, coord, vec2(0.60, 0.41), 0.27, sin((time-29.3)*1.2));

	if (time > 31.0 && time <33.4)
		color = drawGirl2(color, coord, vec2(0.75, 0.435), 0.23, sin((time-31.0)*1.2));
		
	if (time > 23.8 && time < 33.6)
		color = drawBalloon(color, coord, mix(vec2(0.0, 0.77), vec2(1.0, 0.8), min(1.0, (time-23.8)/12.5)), 0.4, time);
	
	gl_FragColor = color;
}