/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                 I want to WebGL                     *
 *   A WebGL demo engine by Segrel/Accesion^Primitive  *
 *   Licenced under beerware, also greetings are nice  *
 *                                                     *
 *   Thanks to iq for ShaderToy!                       *
 *                                                     *
 *   Uses some code from Mozilla Developer Network     *
 *   Partly Google's WebGL init, see webgl-utils.js    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//TODO:
//- music to config.js

var curTime=0.0;
var prevTime=0.0;

//shader vars
var shader_sobeldistortion;

//texture vars
var scene1Tex = null;
var taustaTexture = null;
var overlayTexture = null;
var bambooTexture = null;
var spread1Texture = null;
var scene2Tex = null;
var spread2Texture = null;
var water2Texture = null;
var tree3Texture = null;
var moon3Texture = null;
var spread3Texture = null;
var chica1Texture = null;
var chica2Texture = null;
var chica3Texture = null;
var pmtTexture = null;
var flower1Texture = null;
var flower2Texture = null;
var flower3Texture = null;
var cloud1Texture = null;
var credzTexture = null;
var fallspreadTexture = null;
var spread4Texture = null;
var waterplantTexture = null;
var kalaTexture = null;
var balloonTexture = null;
texturesTotal = 24;

//framebuffer stuff
var rttFramebuffer;
var rttTexture;

//buffer vars
var screenVertexBuffer;
var screenIndexBuffer;

function demoInit() {
	if (loadDone == 0) {
		//put here stuff that only is inited _ONCE_, on the startup
		
		screenVertexBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ARRAY_BUFFER, screenVertexBuffer);
		vertices = [
			-1.0, -1.0, -1.0,
			-1.0,  1.0, -1.0,
			 1.0,  1.0, -1.0,
			 1.0, -1.0, -1.0
		];
		gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(vertices), gl.STATIC_DRAW);
		screenVertexBuffer.itemSize = 3;
		screenVertexBuffer.numItems = 24;

		screenIndexBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, screenIndexBuffer);
		var cubeVertexIndices = [
			0, 1, 2,
			0, 2, 3
		];
		gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(cubeVertexIndices), gl.STATIC_DRAW);
		screenIndexBuffer.itemSize = 1;
		screenIndexBuffer.numItems = 6;
		
		//create a framebuffer
		rttFramebuffer = gl.createFramebuffer();
    gl.bindFramebuffer(gl.FRAMEBUFFER, rttFramebuffer);
    rttFramebuffer.width = 2048;
    rttFramebuffer.height = 2048;

    rttTexture = gl.createTexture();
    gl.bindTexture(gl.TEXTURE_2D, rttTexture);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_NEAREST);
    gl.generateMipmap(gl.TEXTURE_2D);

    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, rttFramebuffer.width, rttFramebuffer.height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);

    var renderbuffer = gl.createRenderbuffer();
    gl.bindRenderbuffer(gl.RENDERBUFFER, renderbuffer);
    gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, rttFramebuffer.width, rttFramebuffer.height);

    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, rttTexture, 0);
    gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, renderbuffer);

    gl.bindTexture(gl.TEXTURE_2D, null);
    gl.bindRenderbuffer(gl.RENDERBUFFER, null);
    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
	}

	//here be stuff that can be reloaded during demo
	
	loadMessage("Loading shaders...");
	shadersInit();
	
	loadMessage("Loading textures...");
	texturesInit();
}

function shadersInit() {	
	//drawing shader
	shader_drawing = shaderLoad("glsl/drawing.vs", "glsl/drawing.fs");
	shader_drawing.vertexPositionAttribute = gl.getAttribLocation(shader_drawing, "aVertexPosition");
	gl.enableVertexAttribArray(shader_drawing.vertexPositionAttribute);

	shader_drawing.uTime = gl.getUniformLocation(shader_drawing, "time");
	
	shader_drawing.samplerUniform = gl.getUniformLocation(shader_drawing, "scene1Tex");
	shader_drawing.taustasamplerUniform = gl.getUniformLocation(shader_drawing, "uSamplerTausta");
	shader_drawing.overlaysamplerUniform = gl.getUniformLocation(shader_drawing, "uSamplerOverlay");
	shader_drawing.bambooTex = gl.getUniformLocation(shader_drawing, "bambooTex");
	shader_drawing.spread1Tex = gl.getUniformLocation(shader_drawing, "spread1Tex");
	shader_drawing.scene2Tex = gl.getUniformLocation(shader_drawing, "scene2Tex");
	shader_drawing.spread2Tex = gl.getUniformLocation(shader_drawing, "spread2Tex");
	shader_drawing.water2Tex = gl.getUniformLocation(shader_drawing, "water2Tex");
	shader_drawing.tree3Tex = gl.getUniformLocation(shader_drawing, "tree3Tex");
	shader_drawing.moon3Tex = gl.getUniformLocation(shader_drawing, "moon3Tex");
	shader_drawing.spread3Tex = gl.getUniformLocation(shader_drawing, "spread3Tex");
	shader_drawing.chica1Tex = gl.getUniformLocation(shader_drawing, "chica1Tex");
	shader_drawing.chica2Tex = gl.getUniformLocation(shader_drawing, "chica2Tex");
	shader_drawing.chica3Tex = gl.getUniformLocation(shader_drawing, "chica3Tex");
	shader_drawing.pmtTex = gl.getUniformLocation(shader_drawing, "pmtTex");
	shader_drawing.flower1Tex = gl.getUniformLocation(shader_drawing, "flower1Tex");
	shader_drawing.flower2Tex = gl.getUniformLocation(shader_drawing, "flower2Tex");
	shader_drawing.flower3Tex = gl.getUniformLocation(shader_drawing, "flower3Tex");
	shader_drawing.cloud1Tex = gl.getUniformLocation(shader_drawing, "cloud1Tex");
	shader_drawing.credzTex = gl.getUniformLocation(shader_drawing, "credzTex");
	shader_drawing.fallspreadTex = gl.getUniformLocation(shader_drawing, "fallspreadTex");
	shader_drawing.spread4Tex = gl.getUniformLocation(shader_drawing, "spread4Tex");
	
	//sobel distortion shader
	shader_sobeldistortion = shaderLoad("glsl/sobeldistortion.vs", "glsl/sobeldistortion.fs");
	shader_sobeldistortion.vertexPositionAttribute = gl.getAttribLocation(shader_sobeldistortion, "aVertexPosition");
	gl.enableVertexAttribArray(shader_sobeldistortion.vertexPositionAttribute);

	shader_sobeldistortion.uTime = gl.getUniformLocation(shader_sobeldistortion, "time");
	
	shader_sobeldistortion.samplerUniform = gl.getUniformLocation(shader_sobeldistortion, "uSampler");
	shader_sobeldistortion.chica2Tex = gl.getUniformLocation(shader_sobeldistortion, "chica2Tex");
	shader_sobeldistortion.balloonTex = gl.getUniformLocation(shader_sobeldistortion, "balloonTex");
}

function texturesInit() {
	if (scene1Tex != null) {gl.deleteTexture(scene1Tex);}
	scene1Tex = textureLoad("img/scene1.jpg");

	if (taustaTexture != null) {gl.deleteTexture(taustaTexture);}
	taustaTexture = textureLoad("img/tausta2.jpg");

	if (overlayTexture != null) {gl.deleteTexture(overlayTexture);}
	overlayTexture = textureLoad("img/overlay1.png");

	if (bambooTexture != null) {gl.deleteTexture(bambooTexture);}
	bambooTexture = textureLoad("img/bamboo.png");

	if (spread1Texture != null) {gl.deleteTexture(spread1Texture);}
	spread1Texture = textureLoad("img/spreadmap1.jpg");
	
	if (scene2Tex != null) {gl.deleteTexture(scene2Tex);}
	scene2Tex = textureLoad("img/scene2.jpg");

	if (spread2Texture != null) {gl.deleteTexture(spread2Texture);}
	spread2Texture = textureLoad("img/spreadmap2.jpg");

	if (water2Texture != null) {gl.deleteTexture(water2Texture);}
	water2Texture = textureLoad("img/scene2water.jpg");

	if (tree3Texture != null) {gl.deleteTexture(tree3Texture);}
	tree3Texture = textureLoad("img/tree.png");

	if (moon3Texture != null) {gl.deleteTexture(moon3Texture);}
	moon3Texture = textureLoad("img/moon.png");

	if (spread3Texture != null) {gl.deleteTexture(spread3Texture);}
	spread3Texture = textureLoad("img/spreadmap3.png");

	if (chica1Texture != null) {gl.deleteTexture(chica1Texture);}
	chica1Texture = textureLoad("img/chica1edit.png");

	if (chica2Texture != null) {gl.deleteTexture(chica2Texture);}
	chica2Texture = textureLoad("img/chica2.png");

	if (chica3Texture != null) {gl.deleteTexture(chica3Texture);}
	chica3Texture = textureLoad("img/chica3.png");

	if (pmtTexture != null) {gl.deleteTexture(pmtTexture);}
	pmtTexture = textureLoad("img/shape.png");

	if (flower1Texture != null) {gl.deleteTexture(flower1Texture);}
	flower1Texture = textureLoad("img/flower1.png");

	if (flower2Texture != null) {gl.deleteTexture(flower2Texture);}
	flower2Texture = textureLoad("img/flower2.png");

	if (flower3Texture != null) {gl.deleteTexture(flower3Texture);}
	flower3Texture = textureLoad("img/flower3.png");

	if (cloud1Texture != null) {gl.deleteTexture(cloud1Texture);}
	cloud1Texture = textureLoad("img/pilvi1.png");

	if (credzTexture != null) {gl.deleteTexture(credzTexture);}
	credzTexture = textureLoad("img/credz.jpg");

	if (fallspreadTexture != null) {gl.deleteTexture(fallspreadTexture);}
	fallspreadTexture = textureLoad("img/fallspread.jpg");
	
	if (spread4Texture != null) {gl.deleteTexture(spread4Texture);}
	spread4Texture = textureLoad("img/spreadmap4.jpg");

	if (waterplantTexture != null) {gl.deleteTexture(waterplantTexture);}
	waterplantTexture = textureLoad("img/waterplants.png");

	if (kalaTexture != null) {gl.deleteTexture(kalaTexture);}
	kalaTexture = textureLoad("img/kalakakkoseen.png");

	if (balloonTexture != null) {gl.deleteTexture(balloonTexture);}
	balloonTexture = textureLoad("img/balloon.png");
}

function demoMain() {

	function demoLoop() {
		if (demoDone) {
			return;
		}

		curTime = audio.currentTime/60.0 * audioBPM * 0.1;
		var deltaTime = curTime - prevTime;
		prevTime = curTime;

		//framebuffer drawing hereh
    gl.bindFramebuffer(gl.FRAMEBUFFER, rttFramebuffer);

		shaderUse(shader_drawing);

 		gl.viewport(0, 0, rttFramebuffer.width, rttFramebuffer.height);
		gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

		gl.uniform1f(currentShader.uTime, curTime);

		gl.bindBuffer(gl.ARRAY_BUFFER, screenVertexBuffer);
		gl.vertexAttribPointer(currentShader.vertexPositionAttribute, screenVertexBuffer.itemSize, gl.FLOAT, false, 0, 0);

		gl.activeTexture(gl.TEXTURE0);
		gl.bindTexture(gl.TEXTURE_2D, overlayTexture);
		gl.uniform1i(currentShader.overlaysamplerUniform, 0);

		gl.activeTexture(gl.TEXTURE1);
		gl.bindTexture(gl.TEXTURE_2D, taustaTexture);
		gl.uniform1i(currentShader.taustasamplerUniform, 1);

		if (curTime <= 19.24) {
			//scene 1 textures
			
			gl.activeTexture(gl.TEXTURE2);
			gl.bindTexture(gl.TEXTURE_2D, scene1Tex);
			gl.uniform1i(currentShader.samplerUniform, 2);
			
			gl.activeTexture(gl.TEXTURE3);
			gl.bindTexture(gl.TEXTURE_2D, bambooTexture);
			gl.uniform1i(currentShader.bambooTex, 3);
			
			gl.activeTexture(gl.TEXTURE4);
			gl.bindTexture(gl.TEXTURE_2D, spread1Texture);
			gl.uniform1i(currentShader.spread1Tex, 4);
			
			gl.activeTexture(gl.TEXTURE5);
			gl.bindTexture(gl.TEXTURE_2D, flower1Texture);
			gl.uniform1i(currentShader.flower1Tex, 5);
			
			gl.activeTexture(gl.TEXTURE6);
			gl.bindTexture(gl.TEXTURE_2D, flower2Texture);
			gl.uniform1i(currentShader.flower2Tex, 6);

			gl.activeTexture(gl.TEXTURE7);
			gl.bindTexture(gl.TEXTURE_2D, flower3Texture);
			gl.uniform1i(currentShader.flower3Tex, 7);
			
			gl.activeTexture(gl.TEXTURE8);
			gl.bindTexture(gl.TEXTURE_2D, cloud1Texture);
			gl.uniform1i(currentShader.pmtTex, 8);
			
			gl.activeTexture(gl.TEXTURE9);
			gl.bindTexture(gl.TEXTURE_2D, chica1Texture);
			gl.uniform1i(currentShader.chica2Tex, 9);

		} else if (curTime <= 32.0) {
			//scene 2 & 1 textures
			
			gl.activeTexture(gl.TEXTURE9);
			gl.bindTexture(gl.TEXTURE_2D, scene2Tex);
			gl.uniform1i(currentShader.scene2Tex, 9);
			
			gl.activeTexture(gl.TEXTURE10);
			gl.bindTexture(gl.TEXTURE_2D, spread2Texture);
			gl.uniform1i(currentShader.spread2Tex, 10);
			
			gl.activeTexture(gl.TEXTURE11);
			gl.bindTexture(gl.TEXTURE_2D, water2Texture);
			gl.uniform1i(currentShader.water2Tex, 11);
			
			//
			gl.activeTexture(gl.TEXTURE2);
			gl.bindTexture(gl.TEXTURE_2D, scene1Tex);
			gl.uniform1i(currentShader.samplerUniform, 2);
			
			gl.activeTexture(gl.TEXTURE3);
			gl.bindTexture(gl.TEXTURE_2D, bambooTexture);
			gl.uniform1i(currentShader.bambooTex, 3);
			
			gl.activeTexture(gl.TEXTURE4);
			gl.bindTexture(gl.TEXTURE_2D, spread1Texture);
			gl.uniform1i(currentShader.spread1Tex, 4);
			
			gl.activeTexture(gl.TEXTURE5);
			gl.bindTexture(gl.TEXTURE_2D, flower1Texture);
			gl.uniform1i(currentShader.flower1Tex, 5);
			
			gl.activeTexture(gl.TEXTURE6);
			gl.bindTexture(gl.TEXTURE_2D, flower2Texture);
			gl.uniform1i(currentShader.flower2Tex, 6);

			gl.activeTexture(gl.TEXTURE7);
			gl.bindTexture(gl.TEXTURE_2D, flower3Texture);
			gl.uniform1i(currentShader.flower3Tex, 7);
			
			gl.activeTexture(gl.TEXTURE8);
			gl.bindTexture(gl.TEXTURE_2D, cloud1Texture);
			gl.uniform1i(currentShader.pmtTex, 8);
			
			gl.activeTexture(gl.TEXTURE12);
			gl.bindTexture(gl.TEXTURE_2D, chica1Texture);
			gl.uniform1i(currentShader.chica2Tex, 12);
			
		} else if (curTime <= 38.4) {
			//scene 3 & 2 textures
			
			gl.activeTexture(gl.TEXTURE2);
			gl.bindTexture(gl.TEXTURE_2D, tree3Texture);
			gl.uniform1i(currentShader.tree3Tex, 2);
			
			gl.activeTexture(gl.TEXTURE3);
			gl.bindTexture(gl.TEXTURE_2D, moon3Texture);
			gl.uniform1i(currentShader.moon3Tex, 3);
			
			gl.activeTexture(gl.TEXTURE4);
			gl.bindTexture(gl.TEXTURE_2D, spread3Texture);
			gl.uniform1i(currentShader.spread3Tex, 4);
			
			//
			gl.activeTexture(gl.TEXTURE9);
			gl.bindTexture(gl.TEXTURE_2D, scene2Tex);
			gl.uniform1i(currentShader.scene2Tex, 9);
			
			gl.activeTexture(gl.TEXTURE10);
			gl.bindTexture(gl.TEXTURE_2D, spread2Texture);
			gl.uniform1i(currentShader.spread2Tex, 10);
			
			gl.activeTexture(gl.TEXTURE11);
			gl.bindTexture(gl.TEXTURE_2D, water2Texture);
			gl.uniform1i(currentShader.water2Tex, 11);
		} else if (curTime < 44.8) {
			//scene 4 & 3 textures

			gl.activeTexture(gl.TEXTURE2);
			gl.bindTexture(gl.TEXTURE_2D, fallspreadTexture);
			gl.uniform1i(currentShader.fallspreadTex, 2);	
			
			gl.activeTexture(gl.TEXTURE3);
			gl.bindTexture(gl.TEXTURE_2D, chica2Texture);
			gl.uniform1i(currentShader.chica2Tex, 3);

			gl.activeTexture(gl.TEXTURE4);
			gl.bindTexture(gl.TEXTURE_2D, chica3Texture);
			gl.uniform1i(currentShader.chica3Tex, 4);

			gl.activeTexture(gl.TEXTURE9);
			gl.bindTexture(gl.TEXTURE_2D, waterplantTexture);
			gl.uniform1i(currentShader.bambooTex, 9);
			
			gl.activeTexture(gl.TEXTURE8);
			gl.bindTexture(gl.TEXTURE_2D, kalaTexture);
			gl.uniform1i(currentShader.water2Tex, 8);

			//
			gl.activeTexture(gl.TEXTURE5);
			gl.bindTexture(gl.TEXTURE_2D, tree3Texture);
			gl.uniform1i(currentShader.tree3Tex, 5);
			
			gl.activeTexture(gl.TEXTURE6);
			gl.bindTexture(gl.TEXTURE_2D, moon3Texture);
			gl.uniform1i(currentShader.moon3Tex, 6);
			
			gl.activeTexture(gl.TEXTURE7);
			gl.bindTexture(gl.TEXTURE_2D, spread3Texture);
			gl.uniform1i(currentShader.spread3Tex, 7);
			
			gl.activeTexture(gl.TEXTURE10);
			gl.bindTexture(gl.TEXTURE_2D, spread4Texture);
			gl.uniform1i(currentShader.spread2Tex, 10);
			
		} else {
			//credz textures
			
			gl.activeTexture(gl.TEXTURE2);
			gl.bindTexture(gl.TEXTURE_2D, credzTexture);
			gl.uniform1i(currentShader.credzTex, 2);
			
			gl.activeTexture(gl.TEXTURE3);
			gl.bindTexture(gl.TEXTURE_2D, pmtTexture);
			gl.uniform1i(currentShader.pmtTex, 3);
		}		

		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, screenIndexBuffer);
		gl.drawElements(gl.TRIANGLES, screenIndexBuffer.numItems, gl.UNSIGNED_SHORT, 0);

    gl.bindTexture(gl.TEXTURE_2D, rttTexture);
    gl.generateMipmap(gl.TEXTURE_2D);
    gl.bindTexture(gl.TEXTURE_2D, null);

    gl.bindFramebuffer(gl.FRAMEBUFFER, null);

		//drawing starts
		shaderUse(shader_sobeldistortion);

		gl.viewport(0, 0, gl.viewportWidth, gl.viewportHeight);
		gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

		gl.uniform1f(currentShader.uTime, curTime);

		gl.bindBuffer(gl.ARRAY_BUFFER, screenVertexBuffer);
		gl.vertexAttribPointer(currentShader.vertexPositionAttribute, screenVertexBuffer.itemSize, gl.FLOAT, false, 0, 0);

		gl.activeTexture(gl.TEXTURE0);
		gl.bindTexture(gl.TEXTURE_2D, rttTexture);
		gl.uniform1i(currentShader.samplerUniform, 0);

		gl.activeTexture(gl.TEXTURE1);
		gl.bindTexture(gl.TEXTURE_2D, chica1Texture);
		gl.uniform1i(currentShader.chica2Tex, 1);

		gl.activeTexture(gl.TEXTURE2);
		gl.bindTexture(gl.TEXTURE_2D, balloonTexture);
		gl.uniform1i(currentShader.balloonTex, 2);

/*			gl.activeTexture(gl.TEXTURE1);
		gl.bindTexture(gl.TEXTURE_2D, taustaTexture);
		gl.uniform1i(currentShader.taustasamplerUniform, 1);*/

		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, screenIndexBuffer);
		gl.drawElements(gl.TRIANGLES, screenIndexBuffer.numItems, gl.UNSIGNED_SHORT, 0);

		if (devmode) {
			document.title = curTime;
		}
		setTimeout(demoLoop, 0);
	}

	if (demoDone) {
		//add what to show after demo is done hereh
		return;
	} else {
		setTimeout(demoLoop, 0);
	}
}
