//--------------------------------------------------------------------------------------
// File: EmptyProject.fx
//
// The effect file for the EmptyProject sample.  
// 
// rywCyreoypreyerwyryrewiyrewghreywt ( All rights )
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float4x4 worldViewProjection : WORLDVIEWPROJ;

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 Proj : PROJECTION;


float3 pos = {0,0,0};


texture texture0;
texture texture1;
 
sampler2D texSampler0 : TEXUNIT0 = sampler_state
{
	Texture	  = (texture0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

sampler2D texSampler1 : TEXUNIT1 = sampler_state
{
	Texture	  = (texture1);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};



struct VS_INPUT
{
    float4 Pos  : POSITION;
	float3 Norm : NORMAL;
	float4 Col  : COLOR0;
	float2 Tex  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Pos_ : POSITION;
	float3 Norm : NORMAL;
	float4 Col  : COLOR0;
	float2 Tex  : TEXCOORD0;
    float4 Pos  : TEXCOORD1;
};


VS_OUTPUT VS( VS_INPUT inp )

//    float3 posi : POSITION )
{
	VS_OUTPUT Out;
//	Out.Pos = mul(inp.Pos, worldViewProjection );
// float4x4 w = World;
// w = mul( w, View );
// w = mul( w, Proj );

float3 koko = mul( inp.Pos.xyz, worldViewProjection );
//Out.Pos_ = float4( koko, 1);
Out.Pos_ = mul(inp.Pos, worldViewProjection );

//Out.Pos = float4(0,0,0,0);

Out.Pos = float4( koko,1 );
 Out.Pos.z = 1.0 / Out.Pos.z;

	Out.Tex = inp.Tex;
	Out.Col = inp.Col;
	
	Out.Norm = mul( inp.Norm, (float3x3)worldViewProjection );
	return Out;
}

struct PIXOUT  
{
	float4 Col;
	float4 Dep;
};

PIXOUT PS_white( VS_OUTPUT IN ) : COLOR
{
	PIXOUT Out;
//	Out.Col = float4(IN.Col.xyz,0.5);
//	Out.Col = IN.Col;
	Out.Col = float4(1,1,1,0.5);
	Out.Dep = float4(0,0,0,0);
	return Out;	
}



PIXOUT PS( VS_OUTPUT IN ) : COLOR
{
//	float3 light = float3(-0.1,0.1,-0.5);
	float3 light = float3(0.9,-0.6,0.1);
	light = normalize( light );
	float k = ( dot( IN.Norm, light ) );
	
	float h = 1.0 / IN.Pos.b;
	float4 dep = tex2D(texSampler1, IN.Pos.xy);
	float2 kom;
	kom.x = dep.z;
	kom.y = atan2(IN.Pos.y, IN.Pos.x );
	float4 tx = tex2D(texSampler0, IN.Tex + dep.yz + kom);
//	float4 tx = tex2D(texSampler0, IN.Tex + kom);
	float4 tx2 = tex2D(texSampler0, IN.Tex - dep );
	
	h = dot( float2(k,h),  IN.Pos.ra );
	
	k *= 2 * k;
	k = (k*h);
	if ( k<0 )
	{
		k = abs(k);
		tx = tx.zyxw;
	}
	tx =  (tx * tx2);
//	return float4(k,k,k,1);


	PIXOUT Out;
	Out.Col = tx * k;
//	h = dep.z;
//	Out.Col = float4(0,0,0,0);
//	Out.Col = h.xxxx;
//	Out.Col = tx
//	Out.Col = tex2D(texSampler1, IN.Tex) *1;
	
	Out.Dep = IN.Pos;
	
	return Out;
	
	
//	return val.Col;
//	return float4(1,1,1,1);
}




PIXOUT PS_flash( VS_OUTPUT IN ) : COLOR
{
	float3 light = float3(-0.6,0.9,-0.1);
	light = normalize( light );
	float k = ( dot( IN.Norm, light ) );
	
	
	float h = 1.5 / IN.Pos.b;
	
	float4 dep = tex2D(texSampler1, IN.Pos.xz);
	float2 kom;
	kom.x = dep.z;
	kom.y = atan2(IN.Pos.y, IN.Pos.x );
	float4 tx = tex2D(texSampler0, IN.Tex + dep.yz + kom);
//	float4 tx = tex2D(texSampler0, IN.Tex + kom);
	float4 tx2 = tex2D(texSampler0, IN.Tex * IN.Tex );
	
	h = 1/abs( dot( cross( IN.Norm + tx.xyz, light ), IN.Pos.xyz ) );
	
	
	if ( k<0 )
	{
		k = abs(k);
		tx = tx.zyxw;
	}
	tx = tx * tx2;
	k = 1/k;
	k = k*k;
	
	k *= h;
//	return float4(k,k,k,1);




	PIXOUT Out;
	Out.Col = tx * k;
//	h = dep.z;
//	Out.Col = float4(0,0,0,0);
//	Out.Col = h.xxxx;
//	Out.Col = tx
//	Out.Col = tex2D(texSampler1, IN.Tex) *1;
	
	Out.Dep = IN.Pos;
	
	return Out;
	
	
//	return val.Col;
//	return float4(1,1,1,1);
}



//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique White
{
    pass P0
    {
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS_white();
		
		ZEnable = false;
		ZWriteEnable = false;
		CullMode = none;
		AlphaBlendEnable = true;
		destblend = invsrcalpha;
		srcblend = srcalpha;
		
//		shademode = gouraud;
//		blendop = add;
		
    }
}


technique RenderScene
{
    pass P0
    {          
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		CullMode = none;
		AlphaBlendEnable = false;
	 	
    }
	/*
    pass P1
    {          
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = GreaterEqual;
		CullMode = cw;
		AlphaBlendEnable = false;
	 	
    }*/
	
}

technique RenderScene2
{
    pass P0
    {          
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS_flash();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		CullMode = none;
		AlphaBlendEnable = false;
	 	
    }
}
