
float kernel[9];

uniform sampler2D tex0;
varying vec2 offs;

uniform float intensity;

float step_w = 1.0/1280.0;
float step_h = 1.0/720.0;


vec2 offset[9];
						 
void main(void)
{
   int i = 0;
   vec4 sum = vec4(0.0);
   
   offset[0] = vec2(-step_w, -step_h);
   offset[1] = vec2(0.0, -step_h);
   offset[2] = vec2(step_w, -step_h);
   
   offset[3] = vec2(-step_w, 0.0);
   offset[4] = vec2(0.0, 0.0);
   offset[5] = vec2(step_w, 0.0);
   
   offset[6] = vec2(-step_w, step_h);
   offset[7] = vec2(0.0, step_h);
   offset[8] = vec2(step_w, step_h);
   
   kernel[0] = 0.0; 			kernel[1] = 1.0*intensity;	kernel[2] = 0.0;
   kernel[3] = 1.0*intensity;	kernel[4] = -4.0*intensity;	kernel[5] = 1.0*intensity;
   kernel[6] = 0.0;   			kernel[7] = 1.0*intensity;	kernel[8] = 0.0;

      
   for( i=0; i<9; i++ )
   {
		vec4 tmp = texture2D(tex0, offs + offset[i]);
		sum += tmp *kernel[i];
   }
   gl_FragColor = sum;
}