
float kernel[9];

uniform sampler2D tex0;
varying vec2 offs;

uniform float sep;

float step_w = sep/1280.0;
float step_h = sep/720.0;


vec2 offset[9];
						 
void main(void)
{
   int i = 0;
   vec4 sum = vec4(0.0);
   
   offset[0] = vec2(-step_w, -step_h);
   offset[1] = vec2(0.0, -step_h);
   offset[2] = vec2(step_w, -step_h);
   
   offset[3] = vec2(-step_w, 0.0);
   offset[4] = vec2(0.0, 0.0);
   offset[5] = vec2(step_w, 0.0);
   
   offset[6] = vec2(-step_w, step_h);
   offset[7] = vec2(0.0, step_h);
   offset[8] = vec2(step_w, step_h);
   
   kernel[0] = 1.0/16.0; 	kernel[1] = 2.0/16.0;	kernel[2] = 1.0/16.0;
   kernel[3] = 2.0/16.0;	kernel[4] = 4.0/16.0;	kernel[5] = 2.0/16.0;
   kernel[6] = 1.0/16.0;   	kernel[7] = 2.0/16.0;	kernel[8] = 1.0/16.0;
   
   
   if(gl_TexCoord[0].s<0.495)
   {
	   for( i=0; i<9; i++ )
	   {
			vec4 tmp = texture2D(tex0, offs + offset[i]);
			sum += tmp * kernel[i];
	   }
   }
   else if( gl_TexCoord[0].s>0.505 )
   {
		sum = texture2D(tex0, offs);
   }
   else
   {
		sum = vec4(1.0, 0.0, 0.0, 1.0);
	}

   gl_FragColor = sum;
}