   
    /**
     * ---------------------------------------------------------
     * HTML5 bL0cKs - Julio Gonzalo AKA McOwen - 2011
     * ---------------------------------------------------------
     * 
     * Coded mainly in Euskal Encounter 19 for Open Game Compo
     * Sound effects and music tracks by www.SoundJay.com (free)
     * 
     */
     
     
    /* GLOBAL VARS */
    
    // game setup
    var msg = "HTML5 bL0cKs";
    var BLOCK_SIZE = 20;
    var ROWS = 20; // canvas height = ROWS * BLOCK_SIZE
    var COLS = 10; // canvas width = COLS * BLOCK_SIZE
    var BLOCK_TYPES = 7;
    var INITIAL_SPEED = 1200;
    var INTRO_BLOCKS = 5;
    var speed = INITIAL_SPEED;
    var lines = 0;
    var score = 0;
    var line_score = 10;
    var position = 1;
    var level = 1;
    var fx_ga = 1.0;
    
    // canvas context
    var ctx;
    var status_ctx;
    var next_ctx;
    var fx_ctx;
    var title_ctx;
    var score_ctx;
    
    // dimensions
    var WIDTH;
    var HEIGHT;
    var SC_WIDTH;
    var SC_HEIGHT;
    var NXT_WIDTH;
    var NXT_HEIGHT;
    var TITLE_WIDTH;
    var TITLE_HEIGHT;
    
    // boards
    var main_board;
    var block_board;
    var collision_board;
    var aux_board;
    
    // interval handlers
    var intro_intervalHandler;
    var intervalHandler;
    var fx_intervalHandler;
    var notify_intervalHandler;
    var title_intervalHandler;
    
    // control vars
    var semaphore = true;
    var notify_semaphore = true;
    var newBlock;
    var currentBlock;
    var nextBlock;
    var linefx_dy = 1;
    var notify_dx = 1;
    var notify_dy = 0;
    var title_x;
    var title_y;
    var title_blur_up = true;
    var title_blur = 1;
    var title_count = 0;
    var game_started = false;
    var play_gameover = true;
    var game_audio;
    var blocks = new Array();
    

    /* --- BEGIN --- */

    /**
     * entry point
     */
    function init() {

        // event listeners
        window.addEventListener('keydown', doKeyDown, true);
        window.addEventListener('keyup', doKeyUp, true);

        // canvas context		  	
        ctx = $("#canvas")[0].getContext("2d");
        fx_ctx = $("#fx_canvas")[0].getContext("2d");
        status_ctx = $("#status_canvas")[0].getContext("2d");
        notify_ctx = $("#notify_canvas")[0].getContext("2d");
        next_ctx = $("#next_canvas")[0].getContext("2d");
        title_ctx = $("#title_canvas")[0].getContext("2d");
        score_ctx = $("#score_canvas")[0].getContext("2d");
        
        // measures
        WIDTH = $("#canvas").width();
        HEIGHT = $("#canvas").height();
        SC_WIDTH = $("#status_canvas").width();
        SC_HEIGHT = $("#status_canvas").height();
        NXT_WIDTH = $("#next_canvas").width();
        NXT_HEIGHT = $("#next_canvas").height();
        TITLE_WIDTH = $("#title_canvas").width();
        TITLE_HEIGHT = $("#title_canvas").height();
        SCORE_WIDTH = $("#score_canvas").width();
        SCORE_HEIGHT = $("#score_canvas").height();

        // font styles
        
        /* status */
        status_ctx.lineWidth = 1;
        status_ctx.font = "14px gameFont";
        gradient = status_ctx.createLinearGradient(0, 0, 100, 100);
        gradient.addColorStop(0, "rgb(255, 0, 0)");
        gradient.addColorStop(1, "rgb(255, 255, 0)");
        status_ctx.fillStyle = gradient;
        status_ctx.shadowColor = "rgb(254, 0, 0)";
        status_ctx.shadowOffsetX = 1;
        status_ctx.shadowOffsetY = 1;
        status_ctx.shadowBlur = 1;
        
        /* notifications */
        notify_ctx.lineWidth = 1;
        notify_ctx.font = "12px notifyFont";
        notify_gradient = notify_ctx.createLinearGradient(0, 0, WIDTH / 2, HEIGHT / 2);
        notify_gradient.addColorStop(0, "rgb(255, 0, 0)");
        notify_gradient.addColorStop(1, "rgb(255, 255, 0)");
        notify_ctx.fillStyle = notify_gradient;
        
        /* title */
        title_ctx.lineWidth = 1;
        title_ctx.font = "28px gameFont";
        title_gradient = title_ctx.createLinearGradient(TITLE_WIDTH / 1.5, TITLE_HEIGHT / 1.5, TITLE_WIDTH, TITLE_HEIGHT);
        title_gradient.addColorStop(0, "#91f206");
        title_gradient.addColorStop(1, "#f2e406");
        title_ctx.fillStyle = title_gradient;
        title_ctx.shadowColor = "#d0f3ff";
        title_ctx.shadowOffsetX = 1;
        title_ctx.shadowOffsetY = 1;
        title_x = TITLE_WIDTH / 6;
        title_y = TITLE_HEIGHT / 2;
        
        /* score */
        score_ctx.font = "320px scoreFont";
        score_ctx.fillStyle = "white";
        score_ctx.globalAlpha = 0.2;
        
        clearNotify();
        clearTitle();

        // intro loop		  		    		  
        intro_intervalHandler = setInterval(intro, 30);
        
        // title loop
        title_intervalHandler = setInterval(titleloop, 50);
    }


    function gameInit() {

        clearTitle();
        clearScore();
        $("#ingame_audio")[0].play();

        // stop intro intervals
        clearInterval(intro_intervalHandler);
        clearInterval(notify_intervalHandler);
        clearInterval(title_intervalHandler);

        // clean game screen
        clearNotify();

        game_started = true;
        score = 0;
        lines = 0;
        level = 1;

        // board initialization
        main_board = initialize();
        block_board = initialize();
        collision_board = initialize();
        aux_board = initialize();

        // init variables
        newBlock = true;

        // main game loop		  		    		  
        intervalHandler = setInterval(loop, INITIAL_SPEED);
    }


    /**
     * Main intro loop
     */
    function intro() {
        ctx.clearRect(0, 0, WIDTH, HEIGHT);
        if (blocks.length < 4) {
            blocks.push(new IntroBlock(0, getRandom(ROWS - 1), getRandom(10) + 4, getRandom(BLOCK_TYPES)));
        }
        for (i = 0; i < blocks.length; i++) {
            if (blocks[i].getAdjustedX() > COLS * BLOCK_SIZE) {
                blocks.splice(i, 1);
            } else {
                blocks[i].paint();
            }
        }
    }


    function IntroBlock(x, y, delta, type) {
        // private fields
        this.x = x;
        this.y = y;
        this.type = type;
        this.delta = delta;
        var aux_x;
        // private methods
        function update(_x, _y, _type) {
            brick(_x, _y, _type, false, ctx);
        }
        // public methods
        this.paint = function () {
            this.x += 0.1 + delta / 200;
            aux = Math.sin(this.x);
            this.y += Math.sin(this.x) / this.delta;
            update(this.x, this.y, this.type);
        }
        this.getAdjustedX = function () {
            return (this.x * BLOCK_SIZE + BLOCK_SIZE);
        }
    }
    
    /**
     * title main loop
     */
     function titleloop() {
     
        if (title_blur == 2 && !title_blur_up && title_count < 30) {
            title_count++;
            return;
        }
        if (title_blur_up) {
           title_blur < 10 ? title_blur++ : title_blur_up = false;
        } else {
           title_blur >= 3 ? title_blur-- : title_blur_up = true;
        }
        
        if (title_blur == 3 ) { title_count = 1; }
        
        clearTitle();
        title_ctx.shadowBlur = title_blur;
        title_ctx.fillText(msg, title_x, title_y);
        title_ctx.strokeText(msg, title_x, title_y);
     }


    /**
     * game main loop
     */

    function loop() {

        // check game over
        if (gameOver()) {
            $("#ingame_audio")[0].pause()
            if (play_gameover) {
                playGameOver();
                play_gameover = false;
            }
            notify_semaphore = true;
            clearInterval(intervalHandler);
            intervalHandler = setInterval(loop, INITIAL_SPEED);
            doGameOver();
            return;
        }

        // check if new block has to be created
        if (newBlock) {
            if (nextBlock != null) {
                createBlock(nextBlock);
            } else {
                //createBlock(getRandom(BLOCK_TYPES) + 1);
                createBlock(7);
            }
            nextBlock = getRandom(BLOCK_TYPES) + 1;
            drawNextBlock(nextBlock);
            newBlock = false;
        }

        // check line
        lines += checkLine();

        // render the game
        render();

        // write status info
        writeStatus();
        
        // next step
        newBlock = nextLine();

        // fix block on board
        if (newBlock) {
            storeBlock();
            clearBlockBoard();
        }
    }

    /* --- utility methods --- */

    function getRandom(position) {
        return Math.floor(Math.random() * position)
    }

    function initialize() {
        board = new Array(COLS);
        for (i = 0; i < COLS; i++) {
            board[i] = new Array(ROWS);
            for (j = 0; j < ROWS; j++) {
                board[i][j] = 0;
            }
        }
        return board;
    }


    function forEachPosition(action) {
        for (i = 0; i < COLS; i++) {
            for (j = 0; j < ROWS; j++) {
                action();
            }
        }
    }

    function forEachPositionInverse(action) {
        for (j = ROWS - 1; j >= 0; j--) {
            for (i = COLS - 1; i >= 0; i--) {
                action();
            }
        }
    }

    function cloneBoard(target, source) {
        for (i = 0; i < COLS; i++) {
            for (j = 0; j < ROWS; j++) {
                target[i][j] = source[i][j];
            }
        }
    }

    function write(text, x, y) {
        status_ctx.fillText(text, x, y);
        status_ctx.strokeText(text, x, y);
    }

    /* ---- game control ---- */

    function gameOver() {
        for (c = 0; c < COLS; c++) {
            if (main_board[c][0] != 0) {
                return true;
            }
        }
        return false;
    }

    function adjustLevelAndSpeed() {
        
        currentLevel = level;
        level = Math.floor(lines / 5) + 1;
        if (level != currentLevel) {
            notify('LEVEL UP');
        }
        speed = Math.floor(INITIAL_SPEED / level);
        clearInterval(intervalHandler);
        intervalHandler = setInterval(loop, speed);
    }

    function checkLine() {
        var isLine;
        var lines = 0;
        var rowLines = new Array();
        for (j = ROWS - 1; j >= 0; j--) {
            isLine = true;
            for (i = COLS - 1; i >= 0; i--) {
                if (main_board[i][j] == 0) {
                    isLine = false;
                    break;
                }
            }
            if (isLine) {
                rowLines.push(j);
                lines++;
                // increase level and speed
                adjustLevelAndSpeed();
            }
        }
        if (rowLines.length != 0) {
            score += rowLines.length * line_score;
            if (rowLines.lenght > 3) {
                score += line_score * 5;
                notify('Extra!');
            }
            if (semaphore) {
                doLineEffects(rowLines);
            }
            writeScore();
            playLine();
            removeLines(rowLines);
        }
        return lines;
    }

    function nextPosition() {
        if (position == 4) {
            position = 1;
        } else {
            position++;
        }
    }

    function doLineEffects(rowLines) {
        semaphore = false;
        cloneBoard(aux_board, main_board);
        fxLines = rowLines.slice();
        fx_intervalHandler = setInterval(function () {
            lineFx(fxLines);
        }, 50);
    }


    function removeLines(rowLines) {
        for (c = 0; c < rowLines.length; c++) {
            line = rowLines.shift();
            for (j = line; j > 0; j--) {
                for (i = COLS - 1; i >= 0; i--) {
                    main_board[i][j] = main_board[i][j - 1];
                }
            }
            checkLine();
        }
    }

    function nextLine() {
        clearCollisionBoard();

        if (checkCollisionAndAdvanceLine()) {
            return true;
        } else {
            renderCollisionBoard();
            return false;
        }
    }

    function checkCollisionAndAdvanceLine() {
        for (j = ROWS - 1; j >= 0; j--) {
            for (i = COLS - 1; i >= 0; i--) {
                if (block_board[i][j] != 0) {
                    // floor collision detection
                    if ((j + 1) == ROWS) {
                        return true;
                    }
                    // block collision detection
                    if (main_board[i][j + 1] == 0) {
                        collision_board[i][j + 1] = block_board[i][j];
                    } else {
                        return true;
                    }
                }
            }
        }
        return false; // no collision
    }


    /* --- render methods --- */

    function clearBlockBoard() {
        forEachPosition(function (clear) {
            block_board[i][j] = 0
        });
    }

    function clearCollisionBoard() {
        forEachPosition(function (clear) {
            collision_board[i][j] = 0;
        });
    }

    function clearGameBoard() {
        ctx.clearRect(0, 0, WIDTH, HEIGHT);
    }

    function clearStatusBoard() {
        status_ctx.clearRect(0, 0, SC_WIDTH, SC_HEIGHT);
    }
    
    function clearNextBlockBoard() {
        next_ctx.clearRect(0, 0, NXT_WIDTH, NXT_HEIGHT);
    }
    
    function clearNotify() {
        notify_ctx.clearRect(0, 0, WIDTH, HEIGHT);
    }

    function clearFx() {
        fx_ctx.clearRect(0, 0, WIDTH, HEIGHT);
    }
    
    function clearTitle() {
        title_ctx.clearRect(0, 0, TITLE_WIDTH, TITLE_HEIGHT);
    }
    
       function clearScore() {
        score_ctx.clearRect(0, 0, SCORE_WIDTH, SCORE_HEIGHT);
    }

    function storeBlock() {
        forEachPosition(function (_store) {
            if (block_board[i][j] != 0) {
                main_board[i][j] = block_board[i][j];
            }
        });
    }

    function renderCollisionBoard() {
        forEachPositionInverse(function (_render) {
            block_board[i][j] = collision_board[i][j];
        });
    }

    function render() {

        // render the main board
        forEachPosition(function (render) {
            brick(i, j, main_board[i][j], true, ctx);
        });

        // render the block board
        forEachPosition(function (render) {
            brick(i, j, block_board[i][j], false, ctx);
        });
    }

    function writeStatus() {
        clearStatusBoard();
        write("LINES: " + lines, 20, 30);
        write("LEVEL: " + level, 20, 60);
        //write("SPEED: " + speed, 20, 90);
        write("NEXT", 20, 140);
    }
    
    function writeScore() {
        clearScore();
        score_ctx.fillText(score, 0, 200);
       // score_ctx.strokeText(score, 0, 200);
    }
    
    function doGameOver() {
        forEachPosition(function (gameover) {
            brick(i, j, getRandom(7) + 1, false, ctx);
        });
        clearNotify();
        rnd_w = getRandom(WIDTH * 0.4);
        rnd_h = getRandom(HEIGHT * 0.8);
        notify_ctx.fillText("GAME OVER", rnd_w, rnd_h);
        notify_ctx.strokeText("GAME OVER", rnd_w, rnd_h);
     }
    
    function drawNextBlock(blockType) {
       clearNextBlockBoard();
       switch (blockType) {
            case 1: 
                brick(1, 0, 1, true, next_ctx);
                brick(0, 1, 1, true, next_ctx);
                brick(1, 1, 1, true, next_ctx);
                brick(2, 1, 1, true, next_ctx);
                break;
            case 2:
                brick(1, 0, 2, true, next_ctx);
                brick(2, 0, 2, true, next_ctx);
                brick(0, 1, 2, true, next_ctx);
                brick(1, 1, 2, true, next_ctx);
                break;
            case 3:
                brick(0, 0, 3, true, next_ctx);
                brick(1, 0, 3, true, next_ctx);
                brick(1, 1, 3, true, next_ctx);
                brick(2, 1, 3, true, next_ctx);
                break;
            case 4:
                brick(0, 0, 4, true, next_ctx);
                brick(0, 1, 4, true, next_ctx);
                brick(1, 0, 4, true, next_ctx);
                brick(1, 1, 4, true, next_ctx);
                break;
            case 5:
                brick(2, 0, 5, true, next_ctx);
                brick(0, 1, 5, true, next_ctx);
                brick(1, 1, 5, true, next_ctx);
                brick(2, 1, 5, true, next_ctx);
                break;
            case 6:
                brick(0, 0, 6, true, next_ctx);
                brick(0, 1, 6, true, next_ctx);
                brick(1, 1, 6, true, next_ctx);
                brick(2, 1, 6, true, next_ctx);
                break;
            case 7:
                brick(0, 1, 7, true, next_ctx);
                brick(1, 1, 7, true, next_ctx);
                brick(2, 1, 7, true, next_ctx);
                brick(3, 1, 7, true, next_ctx);
                break;
       }
    }


    function notify(text) {
        if (notify_semaphore) {
            notify_semaphore = false;
            notify_intervalHandler = setInterval(function () {
                doNotify(text);
            }, 12);
        }
    }

    function doNotify(text) {
        clearNotify();
        notify_ctx.fillText(text, notify_dx++, HEIGHT / 4);
        notify_ctx.strokeText(text, notify_dx, HEIGHT / 4);
        if (notify_dx > HEIGHT) {
            clearInterval(notify_intervalHandler);
            notify_dx = 1;
            notify_dy = 1;
            notify_semaphore = true;
        }
    }

    /* --- sound --- */

    function play(sound) {
        audio_element = document.createElement('audio');
        audio_element.setAttribute('src', sound);
        audio_element.play();
    }

    function playMove() {
        play('audio/move.wav');
    }

    function playTurn() {
        play('audio/turn.wav');
    }

    function playDown() {
        play('audio/down.wav');
    }

    function playLine() {
        play('audio/line.wav');
    }
    
    function playGameOver() {
        play('audio/gameover.wav');
    }


    /* --- block drawing --- */

    function createBlock(type) {

        // initial position of the block
        position = 1;

        // get x start point
        x = getRandom(COLS);
        if (x > COLS - 4) {
            x = COLS - 4
        }

        //1..7
        switch (type) {
        case 1:
            // T
            block_board[x + 1][0] = 1;
            block_board[x][1] = 1;
            block_board[x + 1][1] = 1;
            block_board[x + 2][1] = 1;
            break;
        case 2:
            // S
            block_board[x + 1][0] = 2;
            block_board[x + 2][0] = 2;
            block_board[x][1] = 2;
            block_board[x + 1][1] = 2;
            break;
        case 3:
            // inverted S
            block_board[x][0] = 3;
            block_board[x + 1][0] = 3;
            block_board[x + 1][1] = 3;
            block_board[x + 2][1] = 3;
            break;
        case 4:
            // box
            block_board[x][0] = 4;
            block_board[x + 1][0] = 4;
            block_board[x][1] = 4;
            block_board[x + 1][1] = 4;
            break;
        case 5:
            // L
            block_board[x + 2][0] = 5;
            block_board[x][1] = 5;
            block_board[x + 1][1] = 5;
            block_board[x + 2][1] = 5;
            break;
        case 6:
            // inverted L
            block_board[x][0] = 6;
            block_board[x][1] = 6;
            block_board[x + 1][1] = 6;
            block_board[x + 2][1] = 6;
            break;
        case 7:
            // line
            block_board[x][0] = 7;
            block_board[x + 1][0] = 7;
            block_board[x + 2][0] = 7;
            block_board[x + 3][0] = 7;
            break;
        }
    }


    function lineFx(lines) {

        clearFx();
        fx_ga = fx_ga - 0.1;
        fx_ctx.globalAlpha = fx_ga;

        fx_ctx.save();
        fx_ctx.translate(0, -(linefx_dy++ * 3));

        for (c = 0; c < lines.length; c++) {
            _line = lines[c];
            for (i = COLS - 1; i >= 0; i--) {
                brick(i, _line, aux_board[i][_line], false, fx_ctx);
            }
        }
        fx_ctx.restore();

        if (fx_ga < 0.0) {
            clearInterval(fx_intervalHandler);
            clearFx();
            fx_ga = 1.0;
            linefx_dy = 1;
            semaphore = true;
        }
    }

    function brick(x, y, type, wipe, _ctx) {
        var color1;
        var color2;
        switch (type) {
        case 0:
            if (wipe) {
                _ctx.clearRect(x * BLOCK_SIZE, y * BLOCK_SIZE, BLOCK_SIZE, BLOCK_SIZE);
            }
            return;
        case 1:
            color1 = "#B010FF";
            color2 = "#2B1337";
            break;
        case 2:
            color1 = "#00FF00";
            color2 = "#002900";
            break;
        case 3:
            color1 = "#F80C0C";
            color2 = "#550202";
            break;
        case 4:
            color1 = "#F0F000";
            color2 = "#626200";
            break;
        case 5:
            color1 = "#FFAD06";
            color2 = "#523700";
            break;
        case 6:
            color1 = "#0084FF";
            color2 = "#000034";
            break;
        case 7:
            color1 = "#00F0F0";
            color2 = "#013535";
            break;
        }

        draw(x * BLOCK_SIZE, y * BLOCK_SIZE, BLOCK_SIZE, BLOCK_SIZE, color1, color2, _ctx);
    }

    function draw(x, y, w, h, color1, color2, _ctx) {
        grd = _ctx.createLinearGradient(x, y, w + x, h + y);
        grd.addColorStop(0, color1);
        grd.addColorStop(1, color2);
        _ctx.fillStyle = grd;
        _ctx.fillRect(x, y, w, h);
        _ctx.lineWidth = 0.8;
        _ctx.strokeRect(x + 1, y + 1, w - 2, h - 2);
    }

    /* --- movement --- */

    function doKeyDown(evt) {
        switch (evt.keyCode) {
        case 40:
            // down
            playMove();
            loop();
            break;
        case 37:
            // left
            playMove();
            move('LEFT');
            render();
            break;
        case 39:
            // right
            playMove();
            move('RIGHT');
            render();
            break;
        case 83:
            // S
        case 115:
            // s
            if (!game_started) {
                gameInit();
            }
            break;
        case 27:
            // esc
            clearInterval(intro_intervalHandler);
            clearInterval(intervalHandler);
            clearInterval(fx_intervalHandler);
            clearInterval(notify_intervalHandler);
            clearStatusBoard();
            clearScore();
            clearNextBlockBoard();
            $("#ingame_audio")[0].pause();
            game_started = false;
            init();
        }      
    }

    function doKeyUp(evt) {
        switch (evt.keyCode) {
        case 38:
            // up
            playTurn();
            move('UP');
            render();
            break;
        case 32:
            // space
            playDown();
            goDown();
            break;
        }
    }

    function goDown() {
        while (!newBlock) {
            loop();
        }
    }

    function move(direction) {
        clearCollisionBoard();
        for (j = ROWS - 1; j >= 0; j--) {
            for (i = COLS - 1; i >= 0; i--) {
                if (block_board[i][j] != 0) {

                    if (direction == 'LEFT') {
                        // left wall collision detection
                        if (i == 0) {
                            return true;
                        }
                        // block collision detection
                        if (main_board[i - 1][j] == 0) {
                            collision_board[i - 1][j] = block_board[i][j];
                        } else {
                            return true;
                        }
                    } else if (direction == 'RIGHT') {
                        // right wall collision detection
                        if (i == COLS - 1) {
                            return true;
                        }
                        // block collision detection
                        if (main_board[i + 1][j] == 0) {
                            collision_board[i + 1][j] = block_board[i][j];
                        } else {
                            return true;
                        }
                    } else if (direction == 'UP') {
                        turn(i, j, block_board[i][j]);
                    }
                }
            }
        }
        renderCollisionBoard();
    }

    function turn(x, y, brickType) {
        switch (brickType) {
        case 1:
            switch (position) {
            case 1:
                collision_board[x][y] = brickType;
                collision_board[x - 1][y] = brickType;
                collision_board[x - 1][y + 1] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                break;
            case 2:
                collision_board[x][y] = brickType;
                collision_board[x + 1][y - 1] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                break;
            case 3:
                collision_board[x][y] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x][y - 2] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                break;
            case 4:
                collision_board[x + 1][y - 1] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x][y - 2] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
            break;
        case 2:
            switch (position) {
            case 1:
                collision_board[x][y] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x + 1][y] = brickType;
                collision_board[x + 1][y + 1] = brickType;
                break;
            case 2:
                collision_board[x - 1][y] = brickType;
                collision_board[x - 2][y] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x][y - 1] = brickType;
                break;
            case 3:
                collision_board[x][y] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                break;
            case 4:
                collision_board[x][y - 1] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x][y - 2] = brickType;
                collision_board[x + 1][y - 2] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
            break;
        case 3:
            switch (position) {
            case 1:
                collision_board[x - 1][y] = brickType;
                collision_board[x - 2][y] = brickType;
                collision_board[x - 2][y + 1] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                break;
            case 2:
                collision_board[x][y - 1] = brickType;
                collision_board[x + 1][y] = brickType;
                collision_board[x + 1][y - 1] = brickType;
                collision_board[x + 2][y] = brickType;
                break;
            case 3:
                collision_board[x - 1][y] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x][y - 2] = brickType;
                break;
            case 4:
                collision_board[x][y - 1] = brickType;
                collision_board[x][y - 2] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                collision_board[x + 1][y - 1] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
            break;
        case 4:
            collision_board[x][y] = brickType;
            collision_board[x][y - 1] = brickType;
            collision_board[x - 1][y] = brickType;
            collision_board[x - 1][y - 1] = brickType;
            clearBlockBoard();
            break;
        case 5:
            switch (position) {
            case 1:
                collision_board[x][y] = brickType;
                collision_board[x - 1][y] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                break;
            case 2:
                collision_board[x][y - 2] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                collision_board[x - 2][y - 1] = brickType;
                collision_board[x - 2][y - 2] = brickType;
                break;
            case 3:
                collision_board[x + 1][y - 1] = brickType;
                collision_board[x + 2][y - 1] = brickType;
                collision_board[x + 2][y] = brickType;
                collision_board[x + 2][y + 1] = brickType;
                break;
            case 4:
                collision_board[x][y] = brickType;
                collision_board[x - 1][y] = brickType;
                collision_board[x - 2][y] = brickType;
                collision_board[x][y - 1] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
            break;
        case 6:
            switch (position) {
            case 1:
                collision_board[x - 2][y] = brickType;
                collision_board[x - 2][y - 1] = brickType;
                collision_board[x - 2][y - 2] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                break;
            case 2:
                collision_board[x][y - 2] = brickType;
                collision_board[x + 1][y - 2] = brickType;
                collision_board[x + 2][y - 1] = brickType;
                collision_board[x + 2][y - 2] = brickType;
                break;
            case 3:
                collision_board[x][y] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x][y + 1] = brickType;
                collision_board[x - 1][y + 1] = brickType;
                break;
            case 4:
                collision_board[x][y] = brickType;
                collision_board[x - 1][y] = brickType;
                collision_board[x - 2][y] = brickType;
                collision_board[x - 2][y - 1] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
            break;
        case 7:
            switch (position) {
            case 1:
                collision_board[x - 1][y + 1] = brickType;
                collision_board[x - 1][y] = brickType;
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                break;
            case 2:
                collision_board[x + 1][y - 2] = brickType;
                collision_board[x][y - 2] = brickType;
                collision_board[x - 1][y - 2] = brickType;
                collision_board[x - 2][y - 2] = brickType;
                break;
            case 3:
                collision_board[x - 2][y - 1] = brickType;
                collision_board[x - 2][y] = brickType;
                collision_board[x - 2][y + 1] = brickType;
                collision_board[x - 2][y + 2] = brickType;
                break;
            case 4:
                collision_board[x - 1][y - 1] = brickType;
                collision_board[x][y - 1] = brickType;
                collision_board[x + 1][y - 1] = brickType;
                collision_board[x + 2][y - 1] = brickType;
                break;
            }
            nextPosition();
            clearBlockBoard();
        }
    }

    /* --- END --- */
